/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.IStreamingListener;
import org.eclipse.update.f2.internal.util.PathUtility;

public class ZipDeltaUpdater {
    private int m_currentProcessLevel;
    private Map<String, String> m_renameMap = new HashMap<String, String>();
    private File m_tempDir;

    public void process(File fOld, File fDelta, File fOut, File tmpDir, IStreamingListener listener) throws Exception {
        this.m_tempDir = tmpDir;
        this.m_currentProcessLevel = 0;
        ZipFile zDelta = new ZipFile(fDelta);
        try {
            this.readRenameMappings(zDelta);
            ZipFile zOld = new ZipFile(fOld);
            try {
                this.processImpl(null, "", zOld, zDelta, fOut, listener);
            }
            finally {
                zOld.close();
            }
        }
        finally {
            zDelta.close();
        }
    }

    public void addRenameMapping(String oldPath, String newPath) {
        this.m_renameMap.put(oldPath, newPath);
    }

    protected void readRenameMappings(ZipFile fDelta) throws IOException {
        ZipEntry ze = fDelta.getEntry("rename-map.txt");
        String[] stringArray = new String(FileUtility.readContent(ze.getSize(), fDelta.getInputStream(ze), true), "UTF-8").split("[\\n\\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 0 && !line.startsWith("#")) {
                String[] pair = line.split("[\\t]", 2);
                this.m_renameMap.put(pair[0], pair[1]);
            }
            ++n2;
        }
    }

    protected void processImpl(ZipEntry referenceEntry, String pathPrefix, ZipFile fOld, ZipFile fDelta, File fOut, IStreamingListener listener) throws Exception {
        int outEntryCount = 0;
        ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(fOut));
        try {
            String newName;
            if (this.m_currentProcessLevel == 0) {
                zOut.setLevel(1);
            } else {
                zOut.setLevel(9);
            }
            TreeMap<String, ZipEntry> entryMapOld = new TreeMap<String, ZipEntry>();
            this.readArchive(fOld, entryMapOld);
            TreeMap<String, ZipEntry> entryMapDelta = new TreeMap<String, ZipEntry>();
            this.readArchive(fDelta, entryMapDelta);
            for (String oldName : new ArrayList<String>(entryMapOld.keySet())) {
                newName = this.getNewPathFor(String.valueOf(pathPrefix) + oldName).substring(pathPrefix.length());
                ZipEntry zOld = entryMapOld.get(oldName);
                ZipEntry zDelta = entryMapDelta.get(newName);
                if (!this.acceptUpdateEntry(this.m_currentProcessLevel, String.valueOf(pathPrefix) + newName)) {
                    entryMapDelta.remove(newName);
                    continue;
                }
                if (zDelta == null) {
                    ++outEntryCount;
                    this.writeEntry(newName, zOld, zOld.isDirectory() ? null : fOld.getInputStream(zOld), true, zOut, listener);
                    entryMapDelta.remove(newName);
                    continue;
                }
                if ("!deleted!".equals(zDelta.getComment())) {
                    entryMapDelta.remove(newName);
                    continue;
                }
                if ("!delta-archive!".equals(zDelta.getComment())) {
                    File tmpIn1 = File.createTempFile("old", ".zip", this.m_tempDir);
                    File tmpIn2 = File.createTempFile("delta", ".zip", this.m_tempDir);
                    File tmpOut = File.createTempFile("new", ".zip", this.m_tempDir);
                    try {
                        ++this.m_currentProcessLevel;
                        String subPathPrefix = String.valueOf(pathPrefix) + newName + (newName.endsWith("/") ? "" : "/");
                        FileUtility.streamContent(zOld.getSize(), fOld.getInputStream(zOld), true, new FileOutputStream(tmpIn1), true, null);
                        FileUtility.streamContent(zDelta.getSize(), fDelta.getInputStream(zDelta), true, new FileOutputStream(tmpIn2), true, null);
                        FileUtility.mkdirs(tmpOut.getParentFile());
                        this.processImpl(zDelta, subPathPrefix, new ZipFile(tmpIn1), new ZipFile(tmpIn2), tmpOut, null);
                        zDelta.setComment(null);
                        zDelta.setMethod(8);
                        zDelta.setSize(tmpOut.length());
                        ++outEntryCount;
                        this.writeEntry(newName, zDelta, new FileInputStream(tmpOut), true, zOut, listener);
                    }
                    finally {
                        --this.m_currentProcessLevel;
                        if (!tmpIn1.delete()) {
                            tmpIn1.deleteOnExit();
                        }
                        if (!tmpIn2.delete()) {
                            tmpIn2.deleteOnExit();
                        }
                        if (!tmpOut.delete()) {
                            tmpOut.deleteOnExit();
                        }
                    }
                    entryMapDelta.remove(newName);
                    continue;
                }
                ++outEntryCount;
                this.writeEntry(newName, zDelta, zDelta.isDirectory() ? null : fDelta.getInputStream(zDelta), true, zOut, listener);
                entryMapDelta.remove(newName);
            }
            Iterator<Map.Entry<String, ZipEntry>> it = entryMapDelta.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ZipEntry> e = it.next();
                newName = e.getKey();
                ZipEntry zDelta = e.getValue();
                if (!this.acceptUpdateEntry(this.m_currentProcessLevel, String.valueOf(pathPrefix) + newName)) {
                    it.remove();
                    continue;
                }
                ++outEntryCount;
                this.writeEntry(newName, zDelta, zDelta.isDirectory() ? null : fDelta.getInputStream(zDelta), true, zOut, listener);
            }
        }
        finally {
            if (outEntryCount > 0) {
                try {
                    zOut.finish();
                }
                catch (Throwable throwable) {}
                try {
                    zOut.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                fOld.close();
            }
            catch (Throwable throwable) {}
            try {
                fDelta.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean acceptUpdateEntry(int processLevel, String path) {
        return processLevel != 0 || !"rename-map.txt".equals(path);
    }

    protected String getNewPathFor(String oldPath) {
        String[] oldPathSplit = PathUtility.splitLastPart(oldPath);
        if (oldPathSplit[0].length() > 0) {
            String newBasePath = this.getNewPathFor(oldPathSplit[0]);
            String newPath = this.m_renameMap.get(String.valueOf(newBasePath) + oldPathSplit[1]);
            if (newPath == null) {
                newPath = String.valueOf(newBasePath) + oldPathSplit[1];
            }
            return newPath;
        }
        String newPath = this.m_renameMap.get(oldPath);
        if (newPath == null) {
            newPath = oldPath;
        }
        return newPath;
    }

    protected void readArchive(ZipFile f, Map<String, ZipEntry> entryMap) throws Exception {
        Enumeration<? extends ZipEntry> en = f.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            entryMap.put(ze.getName(), ze);
        }
    }

    protected void writeEntry(String newName, ZipEntry srcEntry, InputStream in, boolean closeInputStream, ZipOutputStream dst, IStreamingListener listener) throws IOException {
        if (!srcEntry.getName().equals(newName)) {
            ZipEntry r = new ZipEntry(newName);
            r.setComment(srcEntry.getComment());
            r.setCrc(srcEntry.getCrc());
            r.setExtra(srcEntry.getExtra());
            r.setMethod(srcEntry.getMethod());
            r.setSize(srcEntry.getSize());
            r.setTime(srcEntry.getTime());
            srcEntry = r;
        }
        srcEntry.setCompressedSize(-1L);
        if ("!deleted!".equals(srcEntry.getComment()) || "!delta-archive!".equals(srcEntry.getComment())) {
            srcEntry.setComment(null);
        }
        dst.putNextEntry(srcEntry);
        if (in != null) {
            FileUtility.streamContent(srcEntry.getSize(), in, closeInputStream, dst, false, listener);
        }
        dst.closeEntry();
    }
}

