/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.create.linux;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.internal.create.AbstractCreateProcessor;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.internal.util.PathUtility;

public class LinuxCreateProcessor
extends AbstractCreateProcessor {
    private static final Pattern JAVA_PATH_PATTERN = Pattern.compile("((.*/)?jre.*/bin/java)", 2);

    public LinuxCreateProcessor(Map<F2Parameter, String> optionMap) {
        super(optionMap);
    }

    @Override
    protected void autoCompleteFullVersionZipStructure(File f, String versionFolderName) throws IOException {
        LogUtility.info("verifying content of " + f.getName());
        String[] requiredFiles = new String[]{this.m_appName, String.valueOf(this.m_appName) + ".ini"};
        File t = new File(String.valueOf(f.getAbsolutePath()) + ".tmp");
        ZipFile z = new ZipFile(f);
        try {
            boolean complete = true;
            String[] stringArray = requiredFiles;
            int n = requiredFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (z.getEntry(s) == null) {
                    complete = false;
                    break;
                }
                ++n2;
            }
            if (complete) {
                return;
            }
            ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(t));
            zOut.setLevel(9);
            try {
                Enumeration<? extends ZipEntry> en = z.entries();
                while (en.hasMoreElements()) {
                    ZipEntry e = en.nextElement();
                    zOut.putNextEntry(new ZipEntry(e.getName()));
                    if (!e.isDirectory()) {
                        FileUtility.streamContent(e.getSize(), z.getInputStream(e), true, zOut, false, null);
                    }
                    zOut.closeEntry();
                }
                if (z.getEntry(requiredFiles[0]) == null) {
                    LogUtility.info(" adding " + requiredFiles[0]);
                    ZipEntry innerExe = z.getEntry(String.valueOf(versionFolderName) + "/" + this.m_appName);
                    zOut.putNextEntry(new ZipEntry(requiredFiles[0]));
                    FileUtility.streamContent(innerExe.getSize(), z.getInputStream(innerExe), true, zOut, false, null);
                    zOut.closeEntry();
                }
                if (z.getEntry(requiredFiles[1]) == null) {
                    LogUtility.info(" adding " + requiredFiles[1]);
                    ZipEntry innerIni = z.getEntry(String.valueOf(versionFolderName) + "/" + this.m_appName + ".ini");
                    zOut.putNextEntry(new ZipEntry(requiredFiles[1]));
                    byte[] data = this.createRootAppIni(z, versionFolderName, FileUtility.readContent(innerIni.getSize(), z.getInputStream(innerIni), true));
                    zOut.write(data);
                    zOut.closeEntry();
                }
            }
            finally {
                zOut.close();
            }
        }
        finally {
            z.close();
        }
        f.delete();
        t.renameTo(f);
    }

    protected byte[] createRootAppIni(ZipFile z, String versionFolderName, byte[] innerIni) throws IOException {
        String startupJar = null;
        String vm = null;
        String launcherLibrary = null;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(new String(innerIni, "UTF-8").split("\\s+")));
        Enumeration<? extends ZipEntry> en = z.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            Matcher m = JAVA_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                vm = m.group(1);
                continue;
            }
            m = PathUtility.LAUNCHER_JAR_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                startupJar = m.group(1);
                continue;
            }
            m = PathUtility.LAUNCHER_LIBRARY_PATH_PATTERN.matcher(ze.getName());
            if (!m.matches()) continue;
            launcherLibrary = m.group(1);
        }
        int i = 0;
        while (i < args.size()) {
            String[] parts;
            String s = (String)args.get(i);
            if ("--launcher.library".equals(s) || "-startup".equals(s) || "-vm".equals(s)) {
                if (!((String)args.get(++i)).startsWith("/")) {
                    args.set(i, String.valueOf(versionFolderName) + "/" + (String)args.get(i));
                }
            } else if (s != null && s.startsWith("-Djava.util.logging.config.file=") && (parts = s.split("=", 2)).length > 1) {
                args.set(i, String.valueOf(parts[0]) + "=" + versionFolderName + "/" + parts[1]);
            }
            ++i;
        }
        if (!args.contains("-vm")) {
            if (vm == null) {
                throw new IOException("could not find a jre in " + z.getName());
            }
            args.add(0, "-vm");
            args.add(1, vm);
        }
        if (!args.contains("-startup")) {
            if (startupJar == null) {
                throw new IOException("could not find a startup jar in " + z.getName());
            }
            args.add(0, "-startup");
            args.add(1, startupJar);
        }
        if (!args.contains("--launcher.library")) {
            if (launcherLibrary == null) {
                throw new IOException("could not find a launcher.library in " + z.getName());
            }
            args.add(0, "--launcher.library");
            args.add(1, launcherLibrary);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : args) {
            buf.append(s);
            buf.append("\n");
        }
        String rootIniContent = buf.toString().trim();
        return rootIniContent.getBytes("UTF-8");
    }
}

