/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.update.f2.internal.DeltaDesc;
import org.eclipse.update.f2.internal.VersionDesc;

public class SiteDesc {
    private final List<VersionDesc> m_versionList;
    private final List<DeltaDesc> m_deltaList;

    public SiteDesc(Collection<VersionDesc> versionList, Collection<DeltaDesc> deltaList) {
        this.m_versionList = Collections.unmodifiableList(new ArrayList<VersionDesc>(versionList));
        this.m_deltaList = Collections.unmodifiableList(new ArrayList<DeltaDesc>(deltaList));
    }

    public String getLatestVersion(String maxVersion) {
        String latest;
        block2: {
            block1: {
                latest = null;
                if (maxVersion != null) break block1;
                if (this.m_versionList.size() <= 0) break block2;
                latest = this.m_versionList.get(this.m_versionList.size() - 1).getVersion();
                break block2;
            }
            for (VersionDesc vd : this.m_versionList) {
                if (!vd.getVersion().equals(maxVersion)) continue;
                latest = vd.getVersion();
                break;
            }
        }
        return latest;
    }

    public List<VersionDesc> getVersionList() {
        return this.m_versionList;
    }

    public List<DeltaDesc> getDeltaList() {
        return this.m_deltaList;
    }

    public String getContent() throws Exception {
        String line;
        StringBuilder buf = new StringBuilder();
        buf.append("#Filename\tSize\tCRC\tContent-Hash\n");
        for (VersionDesc versionDesc : this.m_versionList) {
            line = String.valueOf(versionDesc.getFileName()) + "\t" + versionDesc.getSize() + "\t" + versionDesc.getCrc() + "\t" + versionDesc.getContentHash();
            buf.append(line);
            buf.append("\n");
        }
        for (DeltaDesc deltaDesc : this.m_deltaList) {
            line = String.valueOf(deltaDesc.getFileName()) + "\t" + deltaDesc.getSize() + "\t" + deltaDesc.getCrc();
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[versions=" + this.m_versionList + ", deltas=" + this.m_deltaList + "]";
    }

    public static SiteDesc parse(String content) {
        ArrayList<VersionDesc> versionList = new ArrayList<VersionDesc>();
        ArrayList<DeltaDesc> deltaList = new ArrayList<DeltaDesc>();
        String[] stringArray = content.split("[\\n\\r]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                Object desc;
                String[] a = line.split("[\\s]+");
                if (a[0].startsWith("delta$")) {
                    desc = new DeltaDesc(a[0], Long.parseLong(a[1]), Long.parseLong(a[2]));
                    deltaList.add((DeltaDesc)desc);
                } else {
                    desc = new VersionDesc(a[0], Long.parseLong(a[1]), Long.parseLong(a[2]), Long.parseLong(a[3]));
                    versionList.add((VersionDesc)desc);
                }
            }
            ++n2;
        }
        return new SiteDesc(versionList, deltaList);
    }
}

