/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal.update.linux;

import java.util.Map;

import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.update.AbstractUpdateProcessor;
import org.eclipse.update.f2.internal.update.UpdateContext;

public class LinuxUpdateProcessor extends AbstractUpdateProcessor {

  public LinuxUpdateProcessor(IUserAgent ua, Map<F2Parameter, String> optionMap) {
    super(ua, optionMap);
  }

  @Override
  protected void commit(UpdateContext ctx) throws Throwable {
    new LinuxUpdateCommitter(getUserAgent(), ctx).commit();
  }
}
