/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal;

import org.eclipse.update.f2.internal.util.PathUtility;

/**
 * Descriptor for a delta version zip file named using bundle version naming
 * (delta$app_12.6.0.00$app_12.6.1.00.zip)
 */
public class DeltaDesc {
  private final String m_oldVersion;
  private final String m_newVersion;
  private final String m_fileName;
  private final long m_size;
  private final long m_crc;

  public DeltaDesc(String fileName, long size, long crc) {
    m_fileName = fileName;
    String[] triplet = PathUtility.getPathWithoutArchiveSuffix(fileName).split("[$]");
    if (triplet.length != 3 || !triplet[0].equals("delta")) {
      throw new IllegalArgumentException("delta filename must be in a format like: delta$app_12.6.0.00$app_12.6.1.00.zip. Parsing " + fileName);
    }
    m_oldVersion = triplet[1];
    m_newVersion = triplet[2];
    m_size = size;
    m_crc = crc;
  }

  public String getOldVersion() {
    return m_oldVersion;
  }

  public String getNewVersion() {
    return m_newVersion;
  }

  public String getFileName() {
    return m_fileName;
  }

  public long getSize() {
    return m_size;
  }

  public long getCrc() {
    return m_crc;
  }

  @Override
  public String toString() {
    return getClass().getSimpleName() + "[" + m_oldVersion + "-" + m_newVersion + " " + m_fileName + " " + m_size + " " + Long.toHexString(m_crc) + "]";
  }
}
