/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.update.f2.internal.VersionDesc;

public class PathUtility {
    public static final String DELETED_COMMENT = "!deleted!";
    public static final String DELTA_ARCHIVE_COMMENT = "!delta-archive!";
    public static final String RENAME_ENTRY_NAME = "rename-map.txt";
    public static final Pattern LAUNCHER_LIBRARY_PATH_PATTERN = Pattern.compile("((.*/)?plugins/org\\.eclipse\\.equinox\\.launcher\\.[^/]+)/", 2);
    public static final Pattern LAUNCHER_JAR_PATH_PATTERN = Pattern.compile("((.*/)?plugins/org\\.eclipse\\.equinox\\.launcher_[^/]+\\.jar)", 2);
    public static final Pattern F2_JAR_PATH_PATTERN = Pattern.compile("((.*/)?plugins/org\\.eclipse\\.update\\.f2_[^/]+\\.jar)", 2);
    protected static final Pattern ZIP_PATH_VERSION_PATTERN = Pattern.compile("(.*)_([0-9]+)\\.([0-9]+)\\.([0-9]+)(\\.([^/\\\\]+))?(/|\\.zip|\\.jar)", 2);
    protected static final Pattern ARCHIVE_PATH_PATTERN = Pattern.compile("(.*)\\.(zip|jar)", 2);
    protected static final Pattern FIRST_PATH_PART_PATTERN = Pattern.compile("([^/]+/)([^/]+.*)");
    protected static final Pattern LAST_PATH_PART_PATTERN = Pattern.compile("([^/]+.*/)([^/]+[/]?)");

    private PathUtility() {
    }

    public static String[] splitFirstPart(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("path must not start with /: " + path);
        }
        Matcher m = FIRST_PATH_PART_PATTERN.matcher(path);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[]{path, ""};
    }

    public static String[] splitLastPart(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("path must not start with /: " + path);
        }
        Matcher m = LAST_PATH_PART_PATTERN.matcher(path);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[]{"", path};
    }

    public static String getPathWithoutVersion(String path) {
        String[] split = PathUtility.splitLastPart(path);
        Matcher m = ZIP_PATH_VERSION_PATTERN.matcher(split[1]);
        if (!m.matches()) {
            return null;
        }
        return String.valueOf(split[0]) + m.replaceFirst("$1$7");
    }

    public static boolean isArchiveEntry(ZipEntry z) {
        return !z.isDirectory() && ARCHIVE_PATH_PATTERN.matcher(z.getName()).matches();
    }

    public static String getPathWithoutArchiveSuffix(String path) {
        Matcher m = ARCHIVE_PATH_PATTERN.matcher(path);
        if (m.matches()) {
            return m.group(1);
        }
        return path;
    }

    public static boolean isValidF2DirectoryName(String directoryName, String appName) {
        try {
            VersionDesc versionDesc = new VersionDesc(directoryName, 0L, 0L, 0L);
            return versionDesc.getVersion().startsWith(String.valueOf(appName) + "_");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

