/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update.win32.elev;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.update.f2.internal.update.UpdateContext;
import org.eclipse.update.f2.internal.util.FileUtility;

public class Win32ElevationCaller {
    public void call(UpdateContext ctx, File extractDir) throws Exception {
        List<String> args = this.createArgs(ctx, extractDir);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("cmd.exe");
        cmd.add("/C");
        cmd.add("update.exe");
        cmd.addAll(args);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(extractDir);
        final Process p = pb.redirectErrorStream(true).start();
        Thread t1 = new Thread(){

            @Override
            public void run() {
                InputStream in = p.getInputStream();
                try {
                    while (in.read() >= 0) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        t1.start();
        int code = p.waitFor();
        if (code != 0) {
            throw new Exception("Win32 call failed with code " + code);
        }
        final String log = new String(FileUtility.readContent(-1L, new FileInputStream(new File(ctx.getTempDir(), "winelev-log.txt")), true));
        if (!log.contains("[SUCCESS]")) {
            throw new Exception("Win32 call was performed but log contains errors"){
                private static final long serialVersionUID = 1L;

                @Override
                public void printStackTrace(PrintStream s) {
                    s.println(log);
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                    s.println(log);
                }
            };
        }
    }

    protected String getElevationValue() {
        return "run";
    }

    protected List<String> createArgs(UpdateContext ctx, File extractDir) throws Exception {
        File iniFile = new File(extractDir, "update.ini");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(new String(FileUtility.readContent(-1L, new FileInputStream(iniFile), true), "UTF-8").split("\\s+")));
        if (!args.contains("-vmargs")) {
            args.add("-vmargs");
        }
        int i = 0;
        while (i < args.size()) {
            String s = (String)args.get(i);
            if ("-vmargs".equals(s)) {
                args.add(++i, "-Dupdate.tmpDir=" + ctx.getTempDir().getAbsolutePath().replace(" ", "%20"));
                args.add(i, "-Dupdate.oldVersion=" + ctx.getOldVersion());
                args.add(i, "-Dupdate.newVersion=" + ctx.getNewVersion());
                args.add(i, "-Dupdate.installRootDir=" + ctx.getInstallRootDir().getAbsolutePath().replace(" ", "%20"));
                args.add(i, "-Dupdate.appName=" + ctx.getAppName());
                args.add(i, "-Dwinelev=" + this.getElevationValue());
            }
            ++i;
        }
        return args;
    }
}

