/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.create;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.PathUtility;

public class ZipDeltaBuilder {
    private int m_maxDeltaLevel;
    private int m_maxRenameLevel;
    private int m_currentProcessLevel;
    private Map<String, String> m_renameMap;
    private File m_tempDir;

    public ZipDeltaBuilder() {
        this(0, 0);
    }

    public ZipDeltaBuilder(int maxDeltaLevel, int maxRenameLevel) {
        this.m_maxDeltaLevel = maxDeltaLevel;
        this.m_maxRenameLevel = maxRenameLevel;
        this.m_renameMap = new HashMap<String, String>();
    }

    public boolean process(File fOld, File fNew, File fOut, File tmpDir) throws Exception {
        this.m_tempDir = tmpDir;
        this.m_currentProcessLevel = 0;
        if (!this.acceptDeltaProcessing(this.m_currentProcessLevel)) {
            return true;
        }
        ZipFile zOld = new ZipFile(fOld);
        try {
            boolean bl;
            ZipFile zNew = new ZipFile(fNew);
            try {
                bl = this.processImpl(null, "", zOld, zNew, fOut);
            }
            catch (Throwable throwable) {
                zNew.close();
                throw throwable;
            }
            zNew.close();
            return bl;
        }
        finally {
            zOld.close();
        }
    }

    public void addRenameMapping(String oldPath, String newPath) {
        this.m_renameMap.put(oldPath, newPath);
    }

    protected void writeRenameMappings(ZipOutputStream zOut) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> e : this.m_renameMap.entrySet()) {
            buf.append(e.getKey());
            buf.append("\t");
            buf.append(e.getValue());
            buf.append("\n");
        }
        ZipEntry ze = new ZipEntry("rename-map.txt");
        this.writeEntry(ze.getName(), ze, new ByteArrayInputStream(buf.toString().getBytes("UTF-8")), true, zOut);
    }

    protected boolean processImpl(ZipEntry referenceEntry, String pathPrefix, ZipFile fOld, ZipFile fNew, File fOut) throws Exception {
        ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(fOut));
        int outEntryCount = 0;
        try {
            ZipEntry zNew;
            ZipEntry zOld;
            String newName;
            zOut.setLevel(9);
            TreeMap<String, ZipEntry> entryMapOld = new TreeMap<String, ZipEntry>();
            this.readArchive(fOld, entryMapOld);
            TreeMap<String, ZipEntry> entryMapNew = new TreeMap<String, ZipEntry>();
            this.readArchive(fNew, entryMapNew);
            if (this.acceptDetectRenameOperations(this.m_currentProcessLevel)) {
                this.detectRenameMappings(pathPrefix, new TreeSet<String>(entryMapOld.keySet()), new TreeSet<String>(entryMapNew.keySet()));
            }
            for (String string : new ArrayList<String>(entryMapOld.keySet())) {
                newName = this.getNewPathFor(String.valueOf(pathPrefix) + string).substring(pathPrefix.length());
                zOld = entryMapOld.get(string);
                zNew = entryMapNew.get(newName);
                if (zOld == null || zNew == null) continue;
                try {
                    if (FileUtility.isMatchingSizeAndCrc(zOld, zNew)) continue;
                    if (this.acceptDeltaProcessing(this.m_currentProcessLevel + 1) && PathUtility.isArchiveEntry(zNew) && !FileUtility.isMatchingSizeAndCrc(zOld, zNew)) {
                        File tmpIn1 = File.createTempFile("old", ".zip", this.m_tempDir);
                        File tmpIn2 = File.createTempFile("new", ".zip", this.m_tempDir);
                        File tmpOut = File.createTempFile("delta", ".zip", this.m_tempDir);
                        try {
                            ++this.m_currentProcessLevel;
                            String subPathPrefix = String.valueOf(pathPrefix) + newName + (newName.endsWith("/") ? "" : "/");
                            FileUtility.streamContent(zOld.getSize(), fOld.getInputStream(zOld), true, new FileOutputStream(tmpIn1), true, null);
                            FileUtility.streamContent(zNew.getSize(), fNew.getInputStream(zNew), true, new FileOutputStream(tmpIn2), true, null);
                            FileUtility.mkdirs(tmpOut.getParentFile());
                            boolean equal = this.processImpl(zNew, subPathPrefix, new ZipFile(tmpIn1), new ZipFile(tmpIn2), tmpOut);
                            if (equal) continue;
                            zNew.setComment("!delta-archive!");
                            zNew.setMethod(8);
                            zNew.setSize(tmpOut.length());
                            ++outEntryCount;
                            this.writeEntry(newName, zNew, new FileInputStream(tmpOut), true, zOut);
                            continue;
                        }
                        finally {
                            --this.m_currentProcessLevel;
                            if (!tmpIn1.delete()) {
                                tmpIn1.deleteOnExit();
                            }
                            if (!tmpIn2.delete()) {
                                tmpIn2.deleteOnExit();
                            }
                            if (!tmpOut.delete()) {
                                tmpOut.deleteOnExit();
                            }
                        }
                    }
                    ++outEntryCount;
                    this.writeEntry(newName, zNew, zNew.isDirectory() ? null : fNew.getInputStream(zNew), true, zOut);
                }
                finally {
                    entryMapOld.remove(string);
                    entryMapNew.remove(newName);
                }
            }
            for (Map.Entry entry : entryMapNew.entrySet()) {
                newName = (String)entry.getKey();
                zNew = (ZipEntry)entry.getValue();
                ++outEntryCount;
                this.writeEntry(newName, zNew, zNew.isDirectory() ? null : fNew.getInputStream(zNew), true, zOut);
            }
            for (Map.Entry entry : entryMapOld.entrySet()) {
                String oldName = (String)entry.getKey();
                String newName2 = this.getNewPathFor(String.valueOf(pathPrefix) + oldName).substring(pathPrefix.length());
                zOld = (ZipEntry)entry.getValue();
                zOld.setComment("!deleted!");
                zOld.setCrc(0L);
                zOld.setSize(0L);
                ++outEntryCount;
                this.writeEntry(newName2, zOld, zOld.isDirectory() ? null : fOld.getInputStream(zOld), true, zOut);
            }
            if (this.m_currentProcessLevel == 0) {
                ++outEntryCount;
                this.writeRenameMappings(zOut);
            }
            return outEntryCount == 0;
            {
            }
        }
        finally {
            if (outEntryCount > 0) {
                try {
                    zOut.finish();
                }
                catch (Throwable throwable) {}
            }
            try {
                zOut.close();
            }
            catch (Throwable throwable) {}
            try {
                fOld.close();
            }
            catch (Throwable throwable) {}
            try {
                fNew.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean acceptDeltaProcessing(int level) {
        return level <= this.m_maxDeltaLevel;
    }

    protected boolean acceptDetectRenameOperations(int level) {
        return level <= this.m_maxRenameLevel;
    }

    protected String getNewPathFor(String oldPath) {
        String[] oldPathSplit = PathUtility.splitLastPart(oldPath);
        if (oldPathSplit[0].length() > 0) {
            String newBasePath = this.getNewPathFor(oldPathSplit[0]);
            String newPath = this.m_renameMap.get(String.valueOf(newBasePath) + oldPathSplit[1]);
            if (newPath == null) {
                newPath = String.valueOf(newBasePath) + oldPathSplit[1];
            }
            return newPath;
        }
        String newPath = this.m_renameMap.get(oldPath);
        if (newPath == null) {
            newPath = oldPath;
        }
        return newPath;
    }

    protected void detectRenameMappings(String pathPrefix, TreeSet<String> oldPaths, TreeSet<String> newPaths) {
        if (pathPrefix.length() > 0 && !pathPrefix.endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix must end in /: " + pathPrefix);
        }
        HashMap<String, String> unverToAbsOld = new HashMap<String, String>();
        for (String oldPath : oldPaths) {
            String abs = this.getNewPathFor(String.valueOf(pathPrefix) + oldPath);
            String unver = PathUtility.getPathWithoutVersion(abs);
            if (unver == null) continue;
            unverToAbsOld.put(unver, abs);
        }
        HashMap<String, String> unverToAbsNew = new HashMap<String, String>();
        for (String newPath : newPaths) {
            String abs = this.getNewPathFor(String.valueOf(pathPrefix) + newPath);
            String unver = PathUtility.getPathWithoutVersion(abs);
            if (unver == null) continue;
            unverToAbsNew.put(unver, abs);
        }
        for (String unver : unverToAbsOld.keySet()) {
            String absOld = (String)unverToAbsOld.get(unver);
            String absNew = (String)unverToAbsNew.get(unver);
            if (absOld == null || absNew == null || absOld.equals(absNew)) continue;
            this.addRenameMapping(absOld, absNew);
        }
    }

    protected void readArchive(ZipFile f, Map<String, ZipEntry> entryMap) throws Exception {
        Enumeration<? extends ZipEntry> en = f.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            entryMap.put(ze.getName(), ze);
        }
    }

    protected void writeEntry(String newName, ZipEntry srcEntry, InputStream in, boolean closeInputStream, ZipOutputStream dst) throws IOException {
        if (!srcEntry.getName().equals(newName)) {
            ZipEntry r = new ZipEntry(newName);
            r.setComment(srcEntry.getComment());
            r.setCrc(srcEntry.getCrc());
            r.setExtra(srcEntry.getExtra());
            r.setMethod(srcEntry.getMethod());
            r.setSize(srcEntry.getSize());
            r.setTime(srcEntry.getTime());
            srcEntry = r;
        }
        srcEntry.setCompressedSize(-1L);
        try {
            dst.putNextEntry(srcEntry);
            if (in != null) {
                FileUtility.streamContent(srcEntry.getSize(), in, closeInputStream, dst, false, null);
            }
            dst.closeEntry();
        }
        catch (IOException e) {
            System.err.println("writing entry: " + newName);
            throw e;
        }
    }
}

