/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.update.f2.BasicUserAgent;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.UpdateResult;
import org.eclipse.update.f2.UpdateStrategy;
import org.eclipse.update.f2.internal.create.CreateProcessorFactory;
import org.eclipse.update.f2.internal.update.IUpdateProcessor;
import org.eclipse.update.f2.internal.update.UpdateProcessorFactory;
import org.eclipse.update.f2.internal.update.win32.elev.Win32ElevationTarget;
import org.eclipse.update.f2.internal.util.LogUtility;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Throwable {
        String win32Elev = Main.getStringSysProp("winelev");
        if (win32Elev != null) {
            Win32ElevationTarget.mainDelegate(win32Elev);
            System.exit(0);
            return;
        }
        Map<F2Parameter, String> argMap = Main.parseArgs(args);
        Main.dumpArgs(argMap);
        boolean verbose = argMap.containsKey((Object)F2Parameter.LogVerbose);
        boolean silent = argMap.containsKey((Object)F2Parameter.LogSilent);
        if (verbose) {
            LogUtility.setVerbose();
        } else if (silent) {
            LogUtility.setSilent();
        }
        if (argMap.containsKey((Object)F2Parameter.Create)) {
            Main.commandLineCreate(argMap);
            System.exit(0);
            return;
        }
        if (argMap.containsKey((Object)F2Parameter.Update)) {
            int code = Main.commandLineUpdate(argMap);
            System.exit(code);
            return;
        }
        Main.usage();
        System.exit(-1);
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("Create an f2 updatesite for an OS.ARCH in a updatesite sub folder");
        System.out.println("  java -jar org.eclipse.update.f2_(version).jar -create -site (updatesite root dir) -os (OS) -arch (ARCH) -name (app-name)");
        System.out.println();
        System.out.println("Update an application folder manually");
        System.out.println("  java -jar org.eclipse.update.f2_(version).jar -update -url (updatesite root url) -os (OS) -arch (ARCH) -name (app-name) -install (app-install-root-folder)");
        System.out.println("  the exit code is 0='nothing to do', 200='update done', 500='error'");
        System.out.println();
        System.out.println("Options for logging:");
        System.out.println("  -verbose for detailed logging");
        System.out.println("  -silent for sparse logging");
        System.out.println();
        System.out.println("Options for HTTP Basic auth:");
        System.out.println("  -http.user username");
        System.out.println("  -http.pass password");
        System.out.println("  the config.ini parameters are 'f2.http.user', 'f2.http.pass'");
        System.out.println();
        System.out.println("Option for Windows 7 UAC (user access control)");
        System.out.println("  -uac true|false");
        System.out.println("  default is true if the client zip contains the f2 plug-in, false otherwise");
        System.out.println("  the config.ini parameter is 'f2.uac'");
        System.out.println();
        System.out.println("Option to only update up to a limited version");
        System.out.println("  -version example_1.2.0");
        System.out.println("  the config.ini parameter is 'f2.version'");
        System.out.println();
        System.out.println("Option to enable/disable content hash check on delta updates");
        System.out.println("  -checkhash true");
        System.out.println("  default is true");
        System.out.println("  the config.ini parameter is 'f2.checkhash'");
        System.out.println();
        System.out.println("Option to use specific temp directory");
        System.out.println("  -temp D:/TEMP");
        System.out.println("  the config.ini parameter is 'f2.temp'");
    }

    private static Map<F2Parameter, String> parseArgs(String[] args) {
        HashMap<F2Parameter, String> argMap = new HashMap<F2Parameter, String>();
        int i = 0;
        while (i < args.length) {
            String s = args[i].trim();
            if (s.length() != 0) {
                if (!s.startsWith("-")) {
                    throw new IllegalArgumentException("Expected a '-' at token '" + s + "'");
                }
                F2Parameter key = F2Parameter.parse(s.substring(1));
                String value = null;
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    value = args[++i];
                }
                argMap.put(key, value);
            }
            ++i;
        }
        return argMap;
    }

    private static void dumpArgs(Map<F2Parameter, String> argMap) {
        if (argMap.size() == 0) {
            return;
        }
        System.out.println("Arguments:");
        for (Map.Entry<F2Parameter, String> e : argMap.entrySet()) {
            if (e.getValue() == null) {
                System.out.println(" " + e.getKey().getKey());
                continue;
            }
            System.out.println(" " + e.getKey().getKey() + "=" + e.getValue());
        }
    }

    private static String getStringSysProp(String name) {
        String p = System.getProperty(name, "").trim();
        if (p.length() == 0) {
            return null;
        }
        return p;
    }

    private static void commandLineCreate(Map<F2Parameter, String> argMap) throws Throwable {
        CreateProcessorFactory.getProcessor(argMap).create();
    }

    private static int commandLineUpdate(Map<F2Parameter, String> argMap) throws Throwable {
        BasicUserAgent ua = new BasicUserAgent(argMap);
        IUpdateProcessor processor = UpdateProcessorFactory.getProcessor(ua, argMap);
        UpdateResult result = processor.update(UpdateStrategy.DoUpdate);
        switch (result) {
            case NothingToDo: {
                return 0;
            }
            case UpdateSuccessful: {
                return 200;
            }
            case UnexpectedVersion: {
                return 404;
            }
        }
        return 500;
    }
}

