/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal;

import org.eclipse.update.f2.internal.util.PathUtility;

public class DeltaDesc {
    private final String m_oldVersion;
    private final String m_newVersion;
    private final String m_fileName;
    private final long m_size;
    private final long m_crc;

    public DeltaDesc(String fileName, long size, long crc) {
        this.m_fileName = fileName;
        String[] triplet = PathUtility.getPathWithoutArchiveSuffix(fileName).split("[$]");
        if (triplet.length != 3 || !triplet[0].equals("delta")) {
            throw new IllegalArgumentException("delta filename must be in a format like: delta$app_12.6.0.00$app_12.6.1.00.zip. Parsing " + fileName);
        }
        this.m_oldVersion = triplet[1];
        this.m_newVersion = triplet[2];
        this.m_size = size;
        this.m_crc = crc;
    }

    public String getOldVersion() {
        return this.m_oldVersion;
    }

    public String getNewVersion() {
        return this.m_newVersion;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getCrc() {
        return this.m_crc;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_oldVersion + "-" + this.m_newVersion + " " + this.m_fileName + " " + this.m_size + " " + Long.toHexString(this.m_crc) + "]";
    }
}

