/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.f2.EclipseUserAgent;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.UpdateResult;
import org.eclipse.update.f2.UpdateStrategy;
import org.eclipse.update.f2.internal.update.UpdateProcessorFactory;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.internal.util.PathUtility;
import org.osgi.framework.BundleContext;

public class F2Updater
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.update.f2";
    private static BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
        super.stop(context);
    }

    public static UpdateResult update() {
        return F2Updater.update(null, null, null);
    }

    public static UpdateResult update(UpdateStrategy strategy, Map<F2Parameter, String> optionMap, IUserAgent ua) {
        return F2Updater.update(strategy, optionMap, ua, null);
    }

    public static UpdateResult update(UpdateStrategy strategy, Map<F2Parameter, String> optionMap, IUserAgent ua, IProgressMonitor monitor) {
        if (strategy == null) {
            strategy = UpdateStrategy.DoUpdate;
        }
        HashMap<F2Parameter, String> completeMap = new HashMap<F2Parameter, String>();
        completeMap.put(F2Parameter.OS, Platform.getOS());
        completeMap.put(F2Parameter.Arch, Platform.getOSArch());
        completeMap.putAll(F2Updater.parseOptions());
        if (optionMap != null) {
            completeMap.putAll(optionMap);
        }
        if (!completeMap.containsKey((Object)F2Parameter.InstallDirectory)) {
            File installDir = F2Updater.getInstallDir((String)completeMap.get((Object)F2Parameter.Name));
            completeMap.put(F2Parameter.InstallDirectory, installDir.getAbsolutePath());
        }
        try {
            completeMap.put(F2Parameter.ApplicationRunningDirectory, Platform.getInstallLocation().getURL().getPath());
        }
        catch (Exception installDir) {
            // empty catch block
        }
        if (completeMap.get((Object)F2Parameter.TempDirectory) == null) {
            try {
                completeMap.put(F2Parameter.TempDirectory, FileUtility.createTempDir("oeuf2", "").getAbsolutePath());
            }
            catch (Throwable t) {
                LogUtility.error("Create temp directory", t);
                return UpdateResult.UpdateFailed;
            }
        }
        if (ua == null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ua = new EclipseUserAgent(monitor, completeMap);
        }
        return UpdateProcessorFactory.getProcessor(ua, completeMap).update(strategy);
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public static Map<F2Parameter, String> parseOptions() {
        BundleContext ctx = F2Updater.getContext();
        HashMap<F2Parameter, String> argMap = new HashMap<F2Parameter, String>();
        F2Parameter[] f2ParameterArray = F2Parameter.values();
        int n = f2ParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            F2Parameter key = f2ParameterArray[n2];
            String value = ctx.getProperty("f2." + key.getKey());
            if (value != null) {
                argMap.put(key, value.trim().length() == 0 ? null : value);
            }
            ++n2;
        }
        return argMap;
    }

    private static File getInstallDir(String appName) {
        File installDir = new File(Platform.getInstallLocation().getURL().getPath());
        if (installDir.exists()) {
            if (new File(installDir.getParentFile(), String.valueOf(installDir.getName()) + ".zip").exists()) {
                installDir = installDir.getParentFile();
            } else if (PathUtility.isValidF2DirectoryName(installDir.getName(), appName)) {
                installDir = installDir.getParentFile();
            } else {
                LogUtility.info("Installation directory does not conform to expected F2 application structure. Legacy application?");
            }
        }
        return installDir;
    }
}

