/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2;

import org.eclipse.update.f2.resource.Texts;

public enum UpdateStrategy {
  /**
   * Only check for update, don't run the update
   */
  CheckForUpdate,
  /**
   * Run the update either as delta or full update
   */
  DoUpdate;

  @Override
  public String toString() {
    switch (this) {
      case CheckForUpdate:
        return Texts.CheckForUpdate;
      case DoUpdate:
        return Texts.DoUpdate;
      default:
        return null;
    }
  }
}
