/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2;

import org.eclipse.update.f2.resource.Texts;

public enum UpdateResult {
  /**
   * result for {@link UpdateStrategy#CheckForUpdate}, {@link UpdateStrategy#DoUpdate}
   */
  NothingToDo,
  /**
   * result for {@link UpdateStrategy#DoUpdate}
   */
  UnexpectedVersion,
  /**
   * result for {@link UpdateStrategy#CheckForUpdate}, {@link UpdateStrategy#DoUpdate}
   */
  UpdateFailed,

  /**
   * result for {@link UpdateStrategy#CheckForUpdate}
   */
  UpdateRequired,

  /**
   * result for {@link UpdateStrategy#DoUpdate}
   */
  UpdateSuccessful;

  @Override
  public String toString() {
    switch (this) {
      case NothingToDo:
        return Texts.NothingToDo;
      case UnexpectedVersion:
        return Texts.UnexpectedVersion;
      case UpdateFailed:
        return Texts.UpdateFailed;
      case UpdateRequired:
        return Texts.UpdateRequired;
      case UpdateSuccessful:
        return Texts.UpdateSuccessful;
      default:
        return null;
    }
  }
}
