/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.docx4j.internal.model;

import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.scout.nls.sdk.model.util.Language;

public class NlsLine {
    private String m_key;
    private final HashMap<Language, String> m_translations;
    private final TreeMap<String, String> m_usages;

    public NlsLine() {
        this(null);
    }

    public NlsLine(String key) {
        this.m_key = key;
        this.m_translations = new HashMap();
        this.m_usages = new TreeMap();
    }

    public void addTranslation(Language language, String translation) {
        this.m_translations.put(language, translation);
    }

    public String getTranslation(Language language) {
        return this.m_translations.get(language);
    }

    public String getKey() {
        return this.m_key;
    }

    public void setKey(String newKey) {
        this.m_key = newKey;
    }

    public HashMap<Language, String> getTranslations() {
        return this.m_translations;
    }

    public void addUsage(String usage) {
        this.m_usages.put(usage.toLowerCase(), usage);
    }

    public String[] getUsages() {
        return this.m_usages.values().toArray(new String[this.m_usages.size()]);
    }

    public String getUsagesAsString() {
        StringBuilder b = new StringBuilder();
        String[] usages = this.getUsages();
        int u = 0;
        while (u < usages.length) {
            b.append(usages[u]);
            if (u < usages.length - 1) {
                b.append("\n");
            }
            ++u;
        }
        return b.toString();
    }
}

