/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.docx4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.docx4j.Docx4jProperties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.Styles;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.xlsx4j.jaxb.Context;
import org.xlsx4j.sml.CTBooleanProperty;
import org.xlsx4j.sml.CTBorder;
import org.xlsx4j.sml.CTBorders;
import org.xlsx4j.sml.CTCellAlignment;
import org.xlsx4j.sml.CTCellStyle;
import org.xlsx4j.sml.CTCellStyleXfs;
import org.xlsx4j.sml.CTCellStyles;
import org.xlsx4j.sml.CTCellXfs;
import org.xlsx4j.sml.CTFill;
import org.xlsx4j.sml.CTFills;
import org.xlsx4j.sml.CTFont;
import org.xlsx4j.sml.CTFontSize;
import org.xlsx4j.sml.CTFonts;
import org.xlsx4j.sml.CTNumFmt;
import org.xlsx4j.sml.CTNumFmts;
import org.xlsx4j.sml.CTRElt;
import org.xlsx4j.sml.CTRst;
import org.xlsx4j.sml.CTSst;
import org.xlsx4j.sml.CTStylesheet;
import org.xlsx4j.sml.CTXf;
import org.xlsx4j.sml.CTXstringWhitespace;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Col;
import org.xlsx4j.sml.Cols;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.STCellType;
import org.xlsx4j.sml.SheetData;
import org.xlsx4j.sml.Worksheet;

public class XlsxAdapter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(XlsxAdapter.class);
    private static final DateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    private static final long NUMBER_FORMAT_TIMESTAMP = 203L;
    private static final long NUMBER_FORMAT_DATE = 204L;
    private static final String[] COLUMN_ALPHABET;
    private static final int NUMBER_OF_CHARACTERS_PER_COLUMN = 15;
    private SpreadsheetMLPackage m_workbook;
    private CTSst m_sharedStrings;
    private CTStylesheet m_stylesheet;

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        ISO_8601_DATE_FORMAT.setTimeZone(tz);
        COLUMN_ALPHABET = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    }

    public XlsxAdapter() throws ProcessingException {
        this.initNew();
    }

    public XlsxAdapter(File file) throws ProcessingException {
        if (file == null || !file.exists() || file.length() == 0L) {
            this.initNew();
        } else {
            FileInputStream is;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ProcessingException("Loading xlsx failed", (Throwable)e);
            }
            this.initLoad(is);
        }
    }

    public XlsxAdapter(InputStream inputStream) throws ProcessingException {
        if (inputStream == null) {
            this.initNew();
        } else {
            this.initLoad(inputStream);
        }
    }

    private void initNew() throws ProcessingException {
        try {
            Docx4jProperties.getProperties().setProperty("docx4j.Log4j.Configurator.disabled", "true");
            this.m_workbook = SpreadsheetMLPackage.createPackage();
            this.initNewSharedStrings();
            this.initNewStylesheet();
        }
        catch (Exception e) {
            throw new ProcessingException("Creating xlsx failed", (Throwable)e);
        }
    }

    private void initLoad(InputStream is) throws ProcessingException {
        try {
            Docx4jProperties.getProperties().setProperty("docx4j.Log4j.Configurator.disabled", "true");
            this.m_workbook = (SpreadsheetMLPackage)SpreadsheetMLPackage.load((InputStream)is);
            this.loadSharedStrings();
            this.loadStylesheet();
        }
        catch (Exception e) {
            throw new ProcessingException("Loading xlsx failed", (Throwable)e);
        }
    }

    public SpreadsheetMLPackage getWorkbook() {
        return this.m_workbook;
    }

    public CTStylesheet getStyleSheet() {
        return this.m_stylesheet;
    }

    protected long addSharedString(String value) {
        int i = 0;
        while (i < this.m_sharedStrings.getSi().size()) {
            CTRst item = (CTRst)this.m_sharedStrings.getSi().get(i);
            if (value.equals(item.getT() == null ? null : item.getT().getValue())) {
                return i;
            }
            ++i;
        }
        CTRst item = Context.getsmlObjectFactory().createCTRst();
        CTXstringWhitespace whitespaceValue = new CTXstringWhitespace();
        whitespaceValue.setValue(value);
        item.setT(whitespaceValue);
        this.m_sharedStrings.getSi().add(item);
        return this.m_sharedStrings.getSi().size() - 1;
    }

    private void loadSharedStrings() throws InvalidFormatException {
        SharedStrings sharedStrings = this.m_workbook.getWorkbookPart().getSharedStrings();
        if (sharedStrings != null) {
            this.m_sharedStrings = (CTSst)sharedStrings.getJaxbElement();
        } else {
            this.initNewSharedStrings();
        }
    }

    private void initNewSharedStrings() throws InvalidFormatException {
        SharedStrings shared = new SharedStrings(new PartName("/xl/sharedStrings.xml"));
        this.m_sharedStrings = Context.getsmlObjectFactory().createCTSst();
        shared.setJaxbElement((Object)this.m_sharedStrings);
        this.m_workbook.getWorkbookPart().addTargetPart((Part)shared);
    }

    private void loadStylesheet() throws InvalidFormatException {
        List<Styles> parts = this.getParts(this.m_workbook.getRelationshipsPart(), Styles.class);
        if (parts.size() == 0) {
            this.initNewStylesheet();
        } else if (parts.size() == 1) {
            this.m_stylesheet = (CTStylesheet)parts.get(0).getJaxbElement();
        } else {
            throw new IllegalStateException("Unexpected Styles parts size: " + parts.size());
        }
    }

    private void initNewStylesheet() throws InvalidFormatException {
        Styles styles = new Styles(new PartName("/xl/styles.xml"));
        this.m_stylesheet = Context.getsmlObjectFactory().createCTStylesheet();
        styles.setJaxbElement((Object)this.getStyleSheet());
        this.initStylesheet();
        this.m_workbook.getWorkbookPart().addTargetPart((Part)styles);
    }

    public List<WorksheetPart> getSheets() {
        return this.getParts(this.m_workbook.getRelationshipsPart(), WorksheetPart.class);
    }

    public WorksheetPart createSheet(String name) throws ProcessingException {
        try {
            int size = this.getSheets().size();
            return this.m_workbook.createWorksheetPart(new PartName("/xl/worksheets/sheet" + (size + 1) + ".xml"), name, (long)(size + 1));
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to create new sheet", (Throwable)e);
        }
    }

    public void save(File file) throws ProcessingException {
        try {
            SaveToZipFile saver = new SaveToZipFile((OpcPackage)this.m_workbook);
            saver.save(file);
        }
        catch (Docx4JException e) {
            throw new ProcessingException("Failed to store xlsx file", (Throwable)e);
        }
    }

    public void save(OutputStream outputStream) throws ProcessingException {
        try {
            SaveToZipFile saver = new SaveToZipFile((OpcPackage)this.m_workbook);
            saver.save(outputStream);
        }
        catch (Docx4JException e) {
            throw new ProcessingException("Failed to store xlsx outputStream", (Throwable)e);
        }
    }

    public Row getRow(WorksheetPart sheet, long rowNum) {
        return this.getRow(((Worksheet)sheet.getJaxbElement()).getSheetData(), rowNum);
    }

    protected Row getRow(SheetData sheetData, long rowNum) {
        Row row2;
        for (Row row2 : sheetData.getRow()) {
            if (rowNum + 1L != row2.getR()) continue;
            return row2;
        }
        row2 = Context.getsmlObjectFactory().createRow();
        row2.setR(Long.valueOf(rowNum + 1L));
        sheetData.getRow().add(row2);
        return row2;
    }

    public Cell getCell(Row row, int colNum) {
        Cell cell2;
        String columnLetter = XlsxAdapter.columnIndexToLetterNotation(colNum);
        String cellPosition = String.valueOf(columnLetter) + row.getR();
        for (Cell cell2 : row.getC()) {
            if (!cellPosition.equals(cell2.getR())) continue;
            return cell2;
        }
        cell2 = Context.getsmlObjectFactory().createCell();
        cell2.setR(cellPosition);
        row.getC().add(cell2);
        return cell2;
    }

    public Cell setCellValue(WorksheetPart sheet, long rowNum, int colNum, Object value) throws ProcessingException {
        SheetData sheetData = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Row row = this.getRow(sheetData, rowNum);
        Cell cell = this.getCell(row, colNum);
        this.setCellValue(cell, value);
        return cell;
    }

    public Cell setCellValue(Row row, int colNum, Object value) throws ProcessingException {
        Cell cell = this.getCell(row, colNum);
        this.setCellValue(cell, value);
        return cell;
    }

    public void setCellValue(Cell cell, Object value) throws ProcessingException {
        if (value == null) {
            cell.setT(STCellType.INLINE_STR);
            cell.setIs(null);
        } else if (value instanceof Number) {
            PredefinedStyle format = value instanceof Float || value instanceof Double || value instanceof BigDecimal ? PredefinedStyle.NUMBER_PRECISION : PredefinedStyle.NUMBER;
            cell.setS(this.getPredefinedStyleNumber(format));
            cell.setT(STCellType.N);
            cell.setV(((Number)value).toString());
        } else if (value instanceof Timestamp) {
            cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.FORMAT_TIMESTAMP));
            cell.setV(ISO_8601_DATE_FORMAT.format(new Date(((Timestamp)value).getTime())));
            cell.setV(Double.toString(XlsxAdapter.getExcelDate(new Date(((Timestamp)value).getTime()))));
        } else if (value instanceof Date) {
            cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.FORMAT_DATE));
            cell.setV(ISO_8601_DATE_FORMAT.format((Date)value));
            cell.setV(Double.toString(XlsxAdapter.getExcelDate((Date)value)));
        } else if (value instanceof Boolean) {
            cell.setT(STCellType.B);
            cell.setV((Boolean)value != false ? "1" : "0");
        } else if (value instanceof String && ((String)value).endsWith("%")) {
            cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.PERCENTAGE));
            String s = (String)value;
            try {
                s = s.substring(0, s.length() - 1);
                cell.setV(Double.toString(Double.valueOf(s) / 100.0));
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("item=" + value + " value=" + s, (Throwable)e);
                }
                cell.setV(Long.toString(this.addSharedString("'" + s)));
            }
        } else {
            String s = "" + value;
            if (s.contains("\n")) {
                cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.WRAP_TEXT));
            }
            cell.setV(Long.toString(this.addSharedString(s)));
            cell.setT(STCellType.S);
        }
    }

    public String getCellValue(WorksheetPart sheet, long rowNum, int colNum) {
        SheetData sheetData = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Row row = this.getRow(sheetData, rowNum);
        return this.getCellValue(row, colNum);
    }

    public String getCellValue(Row row, int colNum) {
        return this.getCellValue(this.getCell(row, colNum));
    }

    public String getCellValue(Cell cell) {
        String v = cell.getV();
        if (STCellType.S.equals((Object)cell.getT())) {
            int index = Integer.valueOf(v);
            CTRst ctRst = (CTRst)this.m_sharedStrings.getSi().get(index);
            CTXstringWhitespace t = ctRst.getT();
            if (t != null) {
                return t.getValue();
            }
            List r = ctRst.getR();
            if (CollectionUtility.hasElements((Collection)r)) {
                StringBuilder sb = new StringBuilder();
                for (CTRElt elt : r) {
                    CTXstringWhitespace t2 = elt.getT();
                    if (t2 == null) continue;
                    sb.append(t2.getValue());
                }
                return sb.toString();
            }
        }
        return v;
    }

    public static int getColumnIndex(Cell cell) {
        return XlsxAdapter.letterNotationToColumnIndex(cell.getR());
    }

    public void setCellStyle(Cell cell, PredefinedStyle style) {
        cell.setS(this.getPredefinedStyleNumber(style));
    }

    public Long getPredefinedStyleNumber(PredefinedStyle style) {
        int i = 0;
        while (i < this.getStyleSheet().getCellStyles().getCellStyle().size()) {
            CTCellStyle cellStyle = (CTCellStyle)this.getStyleSheet().getCellStyles().getCellStyle().get(i);
            if (style.name().equals(cellStyle.getName())) {
                return i;
            }
            ++i;
        }
        return null;
    }

    protected final void initStylesheet() {
        this.initFonts();
        this.initFills();
        this.initBorders();
        this.initNumberFormats();
        this.initStyles();
    }

    protected final void initFonts() {
        CTFonts fonts = Context.getsmlObjectFactory().createCTFonts();
        CTFont font = Context.getsmlObjectFactory().createCTFont();
        fonts.getFont().add(font);
        font = Context.getsmlObjectFactory().createCTFont();
        fonts.getFont().add(font);
        CTBooleanProperty boldProperty = Context.getsmlObjectFactory().createCTBooleanProperty();
        boldProperty.setVal(Boolean.TRUE);
        font.getNameOrCharsetOrFamily().add(Context.getsmlObjectFactory().createCTFontB(boldProperty));
        font = Context.getsmlObjectFactory().createCTFont();
        fonts.getFont().add(font);
        CTFontSize fontSize = Context.getsmlObjectFactory().createCTFontSize();
        fontSize.setVal(24.0);
        font.getNameOrCharsetOrFamily().add(Context.getsmlObjectFactory().createCTFontSz(fontSize));
        this.getStyleSheet().setFonts(fonts);
    }

    protected final void initFills() {
        CTFills fills = Context.getsmlObjectFactory().createCTFills();
        CTFill fill = Context.getsmlObjectFactory().createCTFill();
        fills.getFill().add(fill);
        this.getStyleSheet().setFills(fills);
    }

    protected final void initBorders() {
        CTBorders borders = Context.getsmlObjectFactory().createCTBorders();
        CTBorder border = Context.getsmlObjectFactory().createCTBorder();
        borders.getBorder().add(border);
        this.getStyleSheet().setBorders(borders);
    }

    protected final void initNumberFormats() {
        CTNumFmts numFmts = Context.getsmlObjectFactory().createCTNumFmts();
        CTNumFmt numFmt = null;
        numFmt = Context.getsmlObjectFactory().createCTNumFmt();
        numFmt.setNumFmtId(203L);
        numFmt.setFormatCode("dd.MM.yyyy hh:mm");
        numFmts.getNumFmt().add(numFmt);
        numFmt = Context.getsmlObjectFactory().createCTNumFmt();
        numFmt.setNumFmtId(204L);
        numFmt.setFormatCode("dd.MM.yyyy");
        numFmts.getNumFmt().add(numFmt);
        this.getStyleSheet().setNumFmts(numFmts);
    }

    protected final void initStyles() {
        CTCellStyleXfs cellStyleXfs = Context.getsmlObjectFactory().createCTCellStyleXfs();
        CTXf xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(4L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(3L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(203L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(204L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(10L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(1L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(1L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(2L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellStyleXfs.getXf().add(xf);
        this.getStyleSheet().setCellStyleXfs(cellStyleXfs);
        CTCellXfs cellXfs = Context.getsmlObjectFactory().createCTCellXfs();
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(4L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(3L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(203L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(204L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(10L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(0L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        xf.setApplyAlignment(Boolean.TRUE);
        CTCellAlignment alignment = Context.getsmlObjectFactory().createCTCellAlignment();
        alignment.setWrapText(Boolean.TRUE);
        xf.setAlignment(alignment);
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(1L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(1L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        xf.setApplyAlignment(Boolean.TRUE);
        alignment = Context.getsmlObjectFactory().createCTCellAlignment();
        alignment.setWrapText(Boolean.TRUE);
        xf.setAlignment(alignment);
        cellXfs.getXf().add(xf);
        xf = Context.getsmlObjectFactory().createCTXf();
        xf.setNumFmtId(Long.valueOf(0L));
        xf.setFontId(Long.valueOf(2L));
        xf.setFillId(Long.valueOf(0L));
        xf.setBorderId(Long.valueOf(0L));
        xf.setXfId(Long.valueOf(0L));
        cellXfs.getXf().add(xf);
        this.getStyleSheet().setCellXfs(cellXfs);
        CTCellStyles cellStyles = Context.getsmlObjectFactory().createCTCellStyles();
        CTCellStyle cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName("default");
        cellStyle.setXfId(0L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.NUMBER_PRECISION.name());
        cellStyle.setXfId(1L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.NUMBER.name());
        cellStyle.setXfId(2L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.FORMAT_TIMESTAMP.name());
        cellStyle.setXfId(3L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.FORMAT_DATE.name());
        cellStyle.setXfId(4L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.PERCENTAGE.name());
        cellStyle.setXfId(5L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.WRAP_TEXT.name());
        cellStyle.setXfId(6L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.BOLD.name());
        cellStyle.setXfId(7L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.BOLD_AND_WRAP_TEXT.name());
        cellStyle.setXfId(8L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        cellStyle = Context.getsmlObjectFactory().createCTCellStyle();
        cellStyle.setName(PredefinedStyle.TITLE.name());
        cellStyle.setXfId(9L);
        cellStyle.setBuiltinId(Long.valueOf(0L));
        cellStyles.getCellStyle().add(cellStyle);
        this.getStyleSheet().setCellStyles(cellStyles);
    }

    protected final <T extends Part> List<T> getParts(RelationshipsPart rp, Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.traverseRelationships(list, new HashSet<Part>(), rp, clazz);
        return list;
    }

    protected final <T extends Part> void traverseRelationships(List<T> list, Set<Part> handled, RelationshipsPart rp, Class<T> clazz) {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) continue;
            Part part = rp.getPart(r);
            if (clazz.isAssignableFrom(part.getClass())) {
                list.add((Part)clazz.cast(part));
            }
            if (handled.contains(part)) continue;
            handled.add(part);
            if (part.getRelationshipsPart() == null) continue;
            this.traverseRelationships(list, handled, part.getRelationshipsPart(), clazz);
        }
    }

    public static String columnIndexToLetterNotation(int columnIndex) {
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Invalid column " + columnIndex + " provided");
        }
        int base = COLUMN_ALPHABET.length;
        String rightChar = COLUMN_ALPHABET[columnIndex % base];
        if ((columnIndex = columnIndex / base - 1) < 0) {
            return rightChar;
        }
        String middleChar = COLUMN_ALPHABET[columnIndex % base];
        if ((columnIndex = columnIndex / base - 1) < 0) {
            return String.valueOf(middleChar) + rightChar;
        }
        String leftChar = COLUMN_ALPHABET[columnIndex % base];
        if ((columnIndex = columnIndex / base - 1) < 0) {
            return String.valueOf(leftChar) + middleChar + rightChar;
        }
        throw new IllegalArgumentException("Invalid column " + columnIndex + " provided");
    }

    public static int letterNotationToColumnIndex(String letterNotation) {
        int ret = 0;
        int pos = 0;
        int i = letterNotation.length() - 1;
        while (i >= 0) {
            char c = Character.toUpperCase(letterNotation.charAt(i));
            if (c >= COLUMN_ALPHABET[0].charAt(0) && c <= COLUMN_ALPHABET[COLUMN_ALPHABET.length - 1].charAt(0)) {
                int val = c - COLUMN_ALPHABET[0].charAt(0) + 1;
                int pow = (int)Math.pow(COLUMN_ALPHABET.length, pos);
                ret += pow * val;
                ++pos;
            }
            --i;
        }
        return ret - 1;
    }

    public static double getExcelDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int yr = cal.get(1);
        if (cal.get(1) < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        double fraction = (double)(((cal.get(11) * 60 + cal.get(12)) * 60 + cal.get(13)) * 1000 + cal.get(14)) / 8.64E7;
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        double value = fraction + (double)(365 * (yr - 1900) + leapDays + cal.get(6));
        if (value >= 60.0) {
            value += 1.0;
        }
        return value;
    }

    public void fillCSV(int startRowIdx, int startColIdx, String title, String[] infoRowsBefore, String[] infoRowsAfter, Object[][] csv, boolean containsColumnNames, IProgressMonitor monitor) throws ProcessingException {
        List<WorksheetPart> sheets;
        int excelRowIndex = startRowIdx;
        int excelColIndex = startColIdx;
        int columnCount = 0;
        if (csv.length > 0) {
            columnCount = csv[0].length;
        }
        WorksheetPart sheet = (sheets = this.getSheets()).size() <= 0 ? this.createSheet("Sheet1") : sheets.get(0);
        try {
            int n;
            int n2;
            String[] stringArray;
            int c;
            Row row;
            if (title != null) {
                ++excelRowIndex;
                ++excelRowIndex;
            }
            int infoRowsBeforeIndex = -1;
            if (infoRowsBefore != null && infoRowsBefore.length > 0) {
                infoRowsBeforeIndex = excelRowIndex;
                excelRowIndex += infoRowsBefore.length;
                ++excelRowIndex;
            }
            int csvRowIndex = 0;
            Row startRow = this.getRow(sheet, (long)startRowIdx);
            if (containsColumnNames) {
                row = this.getRow(sheet, (long)excelRowIndex);
                c = 0;
                while (c < columnCount) {
                    String name = (String)csv[csvRowIndex][c];
                    if (name != null) {
                        Cell cell = this.setCellValue(row, excelColIndex + c, name);
                        if (name.contains("\n")) {
                            cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.BOLD_AND_WRAP_TEXT));
                        } else {
                            cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.BOLD));
                        }
                    }
                    ++c;
                }
                ++excelRowIndex;
                ++csvRowIndex;
            }
            try {
                if (monitor != null) {
                    monitor.beginTask(null, csv.length);
                    monitor.worked(csvRowIndex);
                }
                while (csvRowIndex < csv.length) {
                    row = this.getRow(sheet, (long)excelRowIndex);
                    if (monitor != null) {
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    c = 0;
                    while (c < columnCount) {
                        Object value = csv[csvRowIndex][c];
                        this.setCellValue(row, c, value);
                        ++c;
                    }
                    ++excelRowIndex;
                    ++csvRowIndex;
                }
            }
            catch (Exception je) {
                throw new ProcessingException("interrupted", (Throwable)je);
            }
            Cols cols = Context.getsmlObjectFactory().createCols();
            int maximumDigitWidth = 7;
            int i = 0;
            while (i < excelColIndex + columnCount) {
                double width = Math.floor(3840.0) / 256.0;
                cols.getCol().add(this.createBestFitColumn(i, width));
                ++i;
            }
            ((Worksheet)sheet.getJaxbElement()).getCols().add(cols);
            if (title != null) {
                Cell cell = this.setCellValue(startRow, startColIdx, title);
                cell.setS(this.getPredefinedStyleNumber(PredefinedStyle.TITLE));
            }
            if (infoRowsBeforeIndex >= 0 && infoRowsBefore != null) {
                int r = infoRowsBeforeIndex;
                stringArray = infoRowsBefore;
                n2 = infoRowsBefore.length;
                n = 0;
                while (n < n2) {
                    String s = stringArray[n];
                    this.setCellValue(sheet, r, excelColIndex, s);
                    ++r;
                    ++n;
                }
            }
            if (infoRowsAfter != null && infoRowsAfter.length > 0) {
                int r = ++excelRowIndex;
                stringArray = infoRowsAfter;
                n2 = infoRowsAfter.length;
                n = 0;
                while (n < n2) {
                    String s = stringArray[n];
                    this.setCellValue(sheet, r, excelColIndex, s);
                    ++r;
                    ++n;
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingException("unable execute operation", (Throwable)e);
        }
    }

    protected Col createBestFitColumn(int columnIndex, double width) {
        Col col = Context.getsmlObjectFactory().createCol();
        col.setBestFit(Boolean.TRUE);
        col.setCustomWidth(Boolean.TRUE);
        col.setMin((long)(columnIndex + 1));
        col.setMax((long)(columnIndex + 1));
        col.setWidth(Double.valueOf(width));
        return col;
    }

    public static enum PredefinedStyle {
        NUMBER_PRECISION,
        NUMBER,
        FORMAT_TIMESTAMP,
        FORMAT_DATE,
        PERCENTAGE,
        WRAP_TEXT,
        BOLD,
        BOLD_AND_WRAP_TEXT,
        TITLE;

    }
}

