/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.docx4j.internal.ui.wizad.nls;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.ui.fields.FileChooserField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class XlsxExportWizardPage
extends WizardPage {
    private Composite m_rootPane;
    private FileChooserField m_fileChooserField;
    private Button m_exportUsageField;
    private Button m_exportInheritedField;
    private String m_fileUrl = null;
    private boolean m_exportUsage;
    private boolean m_exportInherited;

    protected XlsxExportWizardPage() {
        super(XlsxExportWizardPage.class.getName());
        this.setTitle("Export NLS Entries");
        this.setDescription("Exports the NLS entries to a *.xlsx format.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.m_rootPane = new Composite(parent, 0);
        this.m_fileChooserField = new FileChooserField(this.m_rootPane, "Select the .xlsx file to export the data to.");
        this.m_fileChooserField.setButtonText("Browse");
        String extension = ".xlsx";
        this.m_fileChooserField.setExtendsionFilter(new String[]{"*.xlsx"});
        this.m_fileChooserField.setLabelText("XLSX-File:");
        this.m_fileChooserField.addInputChangedListener(24, (IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                XlsxExportWizardPage.this.m_fileUrl = input;
                XlsxExportWizardPage.this.setPageComplete(StringUtility.hasText((CharSequence)XlsxExportWizardPage.this.m_fileUrl));
            }
        });
        this.m_fileChooserField.addInputChangedListener(16, (IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                if (StringUtility.hasText((CharSequence)input) && !input.endsWith(".xlsx")) {
                    XlsxExportWizardPage.this.m_fileChooserField.setValue(String.valueOf(input) + ".xlsx");
                }
            }
        });
        this.m_exportUsageField = new Button(this.m_rootPane, 32);
        this.m_exportUsageField.setText("Export Usage");
        this.m_exportUsageField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XlsxExportWizardPage.this.m_exportUsage = XlsxExportWizardPage.this.m_exportUsageField.getSelection();
            }
        });
        this.m_exportInheritedField = new Button(this.m_rootPane, 32);
        this.m_exportInheritedField.setText("Export Inherited Entries");
        this.m_exportInheritedField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XlsxExportWizardPage.this.m_exportInherited = XlsxExportWizardPage.this.m_exportInheritedField.getSelection();
            }
        });
        this.m_rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_fileChooserField.setLayoutData((Object)new GridData(768));
        this.m_exportUsageField.setLayoutData((Object)new GridData(768));
        this.m_exportInheritedField.setLayoutData((Object)new GridData(768));
    }

    public Control getControl() {
        return this.m_rootPane;
    }

    public void setVisible(boolean visible) {
        if (this.m_rootPane != null && !this.m_rootPane.isDisposed()) {
            this.m_rootPane.setVisible(visible);
        }
    }

    public String getFileUrl() {
        return this.m_fileUrl;
    }

    public boolean isExportInheritedEntries() {
        return this.m_exportInherited;
    }

    public boolean isExportUsage() {
        return this.m_exportUsage;
    }
}

