package org.eclipse.scout.sdk.docx4j.internal.ui.wizad.nls;

import org.eclipse.scout.nls.sdk.extension.AbstractImportExportWizard;
import org.eclipse.scout.sdk.docx4j.internal.operation.ExportNlsToExcelOperation;
import org.eclipse.scout.sdk.jobs.OperationJob;

public class XlsxExportWizard extends AbstractImportExportWizard {

  private XlsxExportWizardPage m_exportPage;

  @Override
  public void addPages() {
    m_exportPage = new XlsxExportWizardPage();
    addPage(m_exportPage);
  }

  @Override
  public boolean performFinish() {
    ExportNlsToExcelOperation op = new ExportNlsToExcelOperation();
    op.setExportUsage(m_exportPage.isExportUsage());
    op.setExportInheritedEntries(m_exportPage.isExportInheritedEntries());
    op.setFileUrl(m_exportPage.getFileUrl());
    op.setProjectToExport(getNlsProject());

    new OperationJob(op).schedule();

    return true;
  }
}
