/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.docx4j.internal.operation;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.docx4j.XlsxAdapter;
import org.eclipse.scout.nls.sdk.internal.search.NlsFindKeysJob;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.docx4j.internal.Docx4jSdkActivator;
import org.eclipse.scout.sdk.docx4j.internal.model.NlsLine;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.search.ui.text.Match;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;

public class ExportNlsToExcelOperation
implements IOperation {
    static final String USAGE_HEADER_TEXT = "Usage";
    private boolean m_exportUsage;
    private boolean m_exportInheritedEntries;
    private String m_fileUrl;
    private INlsProject m_projectToExport;

    public String getOperationName() {
        return "Export NLS Entries to Excel.";
    }

    public void validate() {
        if (!StringUtility.hasText((CharSequence)this.getFileUrl())) {
            throw new IllegalArgumentException("No destination file specified.");
        }
        if (this.getProjectToExport() == null) {
            throw new IllegalArgumentException("NLS Project may not be null.");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        try {
            Collection<NlsLine> entriesToExport = this.getEntriesToExport(monitor);
            this.writeXlsx(entriesToExport);
        }
        catch (ProcessingException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    protected void writeXlsx(Collection<NlsLine> lines) throws ProcessingException {
        File file;
        XlsxAdapter xlsx = new XlsxAdapter();
        WorksheetPart sheet = xlsx.createSheet("NLS Entries");
        this.writeHeader(xlsx, sheet);
        long row = 1L;
        for (NlsLine l : lines) {
            this.writeLine(xlsx, sheet, l, row++);
        }
        String fileUrl = this.getFileUrl();
        String xlsxExtension = ".xlsx";
        if (!fileUrl.toLowerCase().endsWith(xlsxExtension)) {
            fileUrl = String.valueOf(fileUrl) + xlsxExtension;
        }
        if ((file = new File(fileUrl)).exists()) {
            file.delete();
        } else {
            File folder = file.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new ProcessingException("Cannot create folder '" + folder.getAbsolutePath() + "'.");
            }
        }
        xlsx.save(file);
    }

    private void writeLine(XlsxAdapter xlsx, WorksheetPart sheet, NlsLine line, long rowIndex) throws ProcessingException {
        Row row = xlsx.getRow(sheet, rowIndex);
        int col = 0;
        xlsx.setCellValue(row, col++, (Object)line.getKey());
        Language[] languageArray = this.getProjectToExport().getAllLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            xlsx.setCellValue(row, col++, (Object)line.getTranslation(lang));
            ++n2;
        }
        if (this.isExportUsage()) {
            Cell cell = xlsx.getCell(row, col);
            cell.setS(xlsx.getPredefinedStyleNumber(XlsxAdapter.PredefinedStyle.WRAP_TEXT));
            xlsx.setCellValue(row, col, (Object)line.getUsagesAsString());
        }
    }

    private void writeHeader(XlsxAdapter xlsx, WorksheetPart sheet) throws ProcessingException {
        Row headerRow = xlsx.getRow(sheet, 0L);
        int col = 0;
        xlsx.setCellStyle(xlsx.getCell(headerRow, col), XlsxAdapter.PredefinedStyle.BOLD);
        xlsx.setCellValue(headerRow, col++, (Object)Language.LANGUAGE_KEY.getIsoCode());
        Language[] languageArray = this.getProjectToExport().getAllLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language l = languageArray[n2];
            xlsx.setCellStyle(xlsx.getCell(headerRow, col), XlsxAdapter.PredefinedStyle.BOLD);
            xlsx.setCellValue(headerRow, col++, (Object)l.getIsoCode());
            ++n2;
        }
        if (this.isExportUsage()) {
            xlsx.setCellStyle(xlsx.getCell(headerRow, col), XlsxAdapter.PredefinedStyle.BOLD);
            xlsx.setCellValue(headerRow, col++, (Object)USAGE_HEADER_TEXT);
        }
    }

    protected Collection<NlsLine> getEntriesToExport(IProgressMonitor monitor) {
        Language[] languages = this.getProjectToExport().getAllLanguages();
        INlsEntry[] entries = this.getProjectToExport().getAllEntries();
        TreeMap<String, NlsLine> lines = new TreeMap<String, NlsLine>();
        INlsEntry[] iNlsEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            INlsEntry entry = iNlsEntryArray[n2];
            if (entry.getType() == 1 || this.isExportInheritedEntries()) {
                String key = entry.getKey();
                NlsLine line = new NlsLine(key);
                Language[] languageArray = languages;
                int n3 = languages.length;
                int n4 = 0;
                while (n4 < n3) {
                    Language lang = languageArray[n4];
                    line.addTranslation(lang, entry.getTranslation(lang));
                    ++n4;
                }
                lines.put(key, line);
            }
            ++n2;
        }
        if (this.isExportUsage()) {
            NlsFindKeysJob job = new NlsFindKeysJob(this.getProjectToExport(), "Calculate NLS Entry Usage");
            job.run(monitor);
            for (NlsLine l : lines.values()) {
                Match[] matches;
                Match[] matchArray = matches = job.getMatches(l.getKey());
                int n5 = matches.length;
                int n6 = 0;
                while (n6 < n5) {
                    Match m = matchArray[n6];
                    try {
                        String path = this.findPathOfMatch(m);
                        if (path != null) {
                            l.addUsage(path);
                        }
                    }
                    catch (JavaModelException e) {
                        Docx4jSdkActivator.logWarning("could not resolve path of match in '" + m.getElement() + "'.", e);
                    }
                    ++n6;
                }
            }
        }
        return lines.values();
    }

    private String findPathOfMatch(Match match) throws JavaModelException {
        ICompilationUnit compilationUnit;
        IJavaElement element;
        if (match.getElement() instanceof IFile && TypeUtility.exists((IJavaElement)(element = (compilationUnit = (ICompilationUnit)JavaCore.create((IFile)((IFile)match.getElement()))).getElementAt(match.getOffset())))) {
            LinkedList<String> pathTokens = new LinkedList<String>();
            this.createPath(element, pathTokens);
            if (pathTokens.size() > 0) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < pathTokens.size()) {
                    builder.append(pathTokens.get(i));
                    if (i < pathTokens.size() - 1) {
                        builder.append(" - ");
                    }
                    ++i;
                }
                return builder.toString();
            }
        }
        return null;
    }

    private void createPath(IJavaElement element, LinkedList<String> pathTokens) {
        switch (element.getElementType()) {
            case 5: {
                return;
            }
            case 7: 
            case 9: {
                pathTokens.addFirst(element.getElementName());
                IJavaElement parent = element.getParent();
                if (!TypeUtility.exists((IJavaElement)parent)) break;
                this.createPath(parent, pathTokens);
            }
        }
    }

    public boolean isExportUsage() {
        return this.m_exportUsage;
    }

    public void setExportUsage(boolean m_exportUsage) {
        this.m_exportUsage = m_exportUsage;
    }

    public String getFileUrl() {
        return this.m_fileUrl;
    }

    public void setFileUrl(String m_fileUrl) {
        this.m_fileUrl = m_fileUrl;
    }

    public INlsProject getProjectToExport() {
        return this.m_projectToExport;
    }

    public void setProjectToExport(INlsProject m_projectToExport) {
        this.m_projectToExport = m_projectToExport;
    }

    public boolean isExportInheritedEntries() {
        return this.m_exportInheritedEntries;
    }

    public void setExportInheritedEntries(boolean m_exportInheritedEntries) {
        this.m_exportInheritedEntries = m_exportInheritedEntries;
    }
}

