package org.eclipse.scout.sdk.docx4j.internal.ui.wizad.nls;

import org.eclipse.scout.nls.sdk.extension.AbstractImportExportWizard;
import org.eclipse.scout.sdk.docx4j.internal.operation.ImportNlsFromExcelOperation;
import org.eclipse.scout.sdk.jobs.OperationJob;

public class XlsxImportWizard extends AbstractImportExportWizard {

  private XlsxImportWizardPage m_importPage;

  @Override
  public void addPages() {
    m_importPage = new XlsxImportWizardPage();
    addPage(m_importPage);
  }

  @Override
  public boolean performFinish() {
    ImportNlsFromExcelOperation op = new ImportNlsFromExcelOperation();
    op.setFileUrl(m_importPage.getFileUrl());
    op.setProjectToImportTo(getNlsProject());
    OperationJob j = new OperationJob(op);
    j.schedule();
    return true;
  }

}
