/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.docx4j.internal.operation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.docx4j.XlsxAdapter;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsFolder;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.simple.model.ws.NlsType;
import org.eclipse.scout.nls.sdk.simple.model.ws.project.SimpleNlsProject;
import org.eclipse.scout.nls.sdk.simple.ui.dialog.language.TranslationFileNewModel;
import org.eclipse.scout.nls.sdk.ui.action.INewLanguageContext;
import org.eclipse.scout.sdk.docx4j.internal.model.NlsLine;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.SheetData;
import org.xlsx4j.sml.Worksheet;

public class ImportNlsFromExcelOperation
implements IOperation {
    private String m_fileUrl;
    private INlsProject m_projectToImportTo;
    private HashSet<String> m_messages;

    public String getOperationName() {
        return "Import NLS Entries from Excel.";
    }

    public void validate() {
        if (!StringUtility.hasText((CharSequence)this.getFileUrl())) {
            throw new IllegalArgumentException("No source file specified.");
        }
        if (this.getProjectToImportTo() == null) {
            throw new IllegalArgumentException("NLS Project may not be null.");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        try {
            XlsxAdapter xlsx;
            List sheets;
            this.m_messages = new HashSet();
            String fileUrl = this.getFileUrl();
            String xlsxExtension = ".xlsx";
            if (!fileUrl.toLowerCase().endsWith(xlsxExtension)) {
                fileUrl = String.valueOf(fileUrl) + xlsxExtension;
            }
            if ((sheets = (xlsx = new XlsxAdapter(new File(fileUrl))).getSheets()).size() > 0) {
                if (sheets.size() > 1) {
                    this.m_messages.add("Multiple sheets have been found in the Excel file. The import used the first sheet only.");
                }
                List<NlsLine> lines = this.readLinesFromSheet(xlsx, (WorksheetPart)sheets.get(0), monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                this.storeEntries(lines, monitor);
            } else {
                this.m_messages.add("No sheet has been found in the Excel file.");
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    private void storeEntries(List<NlsLine> lines, IProgressMonitor monitor) {
        INlsProject p = this.getProjectToImportTo();
        for (NlsLine l : lines) {
            NlsEntry newEntry = new NlsEntry(l.getKey(), p);
            for (Map.Entry<Language, String> e : l.getTranslations().entrySet()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (!p.containsLanguage(e.getKey()) && p instanceof SimpleNlsProject) {
                    NlsType txtProvSvc = ((SimpleNlsProject)p).getNlsType();
                    IFolder fld = txtProvSvc.getType().getJavaProject().getProject().getFolder(txtProvSvc.getTranslationsFolderName());
                    INewLanguageContext translationCreationContext = p.getTranslationCreationContext();
                    TranslationFileNewModel model = (TranslationFileNewModel)translationCreationContext.getModel();
                    model.setLanguageIso(e.getKey().getIsoCode());
                    model.setFolder((INlsFolder)new NlsFolder(fld, 4));
                    translationCreationContext.execute(monitor);
                }
                newEntry.addTranslation(e.getKey(), e.getValue());
            }
            p.updateRow((INlsEntry)newEntry, monitor);
        }
    }

    private List<NlsLine> readLinesFromSheet(XlsxAdapter xlsx, WorksheetPart sheet, IProgressMonitor monitor) throws CoreException {
        ArrayList<NlsLine> lines = new ArrayList<NlsLine>();
        SheetData data = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Map<Integer, Language> langIndexes = null;
        for (Row row : data.getRow()) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (langIndexes == null || langIndexes.size() < 1) {
                langIndexes = this.parseHeaderRow(xlsx, row);
                continue;
            }
            NlsLine parsedLine = this.readRow(xlsx, row, langIndexes);
            if (parsedLine == null) continue;
            lines.add(parsedLine);
        }
        return lines;
    }

    private NlsLine readRow(XlsxAdapter xlsx, Row row, Map<Integer, Language> langIndexes) {
        NlsLine nlsLine = new NlsLine();
        for (Cell c : row.getC()) {
            Language l = langIndexes.get(XlsxAdapter.getColumnIndex((Cell)c));
            String cellContent = StringUtility.trim((String)xlsx.getCellValue(c));
            if (l == null || cellContent == null) continue;
            if (Language.LANGUAGE_KEY.equals((Object)l)) {
                nlsLine.setKey(cellContent);
                continue;
            }
            nlsLine.addTranslation(l, cellContent);
        }
        if (!StringUtility.hasText((CharSequence)nlsLine.getKey())) {
            return null;
        }
        if (!StringUtility.hasText((CharSequence)nlsLine.getTranslation(Language.LANGUAGE_DEFAULT))) {
            return null;
        }
        return nlsLine;
    }

    private Map<Integer, Language> parseHeaderRow(XlsxAdapter xlsx, Row headerRow) throws CoreException {
        HashMap<Integer, Language> languages = new HashMap<Integer, Language>();
        for (Cell cell : headerRow.getC()) {
            String cellContent = StringUtility.trim((String)xlsx.getCellValue(cell));
            int index = XlsxAdapter.getColumnIndex((Cell)cell);
            if (!StringUtility.hasText((CharSequence)cellContent)) continue;
            if (Language.LANGUAGE_KEY.getIsoCode().equals(cellContent)) {
                languages.put(index, Language.LANGUAGE_KEY);
                continue;
            }
            if (Language.LANGUAGE_DEFAULT.getIsoCode().equals(cellContent)) {
                languages.put(index, Language.LANGUAGE_DEFAULT);
                continue;
            }
            if ("Usage".equals(cellContent)) continue;
            Locale locale = null;
            String[] parts = cellContent.split("_");
            switch (parts.length) {
                case 1: {
                    locale = new Locale(parts[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(parts[0], parts[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(parts[0], parts[1], parts[3]);
                }
            }
            if (locale == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.docx4j", "could not parse Iso language '" + cellContent + "'."));
            }
            languages.put(index, new Language(locale));
        }
        return languages;
    }

    public String getFileUrl() {
        return this.m_fileUrl;
    }

    public void setFileUrl(String m_fileUrl) {
        this.m_fileUrl = m_fileUrl;
    }

    public INlsProject getProjectToImportTo() {
        return this.m_projectToImportTo;
    }

    public void setProjectToImportTo(INlsProject m_projectToImportTo) {
        this.m_projectToImportTo = m_projectToImportTo;
    }
}

