package org.apache.log4j;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/**
 * Logging Bridge that delegates the log4j API used by org.docx4j to the eclipse logger.
 * <p>
 * Note: Only fatal errors are forwarded because the other log is not of interest.
 * </p>
 * 
 * @author Matthias Villiger
 */
public class Logger {

  private static final Logger INSTANCE = new Logger(null);
  private static final String HOST_BUNDLE = "com.bsiag.org.docx4j";

  Logger(String name) {
  }

  public static Logger getLogger(String name) {
    return INSTANCE;
  }

  public static Logger getLogger(Class<?> clazz) {
    return INSTANCE;
  }

  public boolean isDebugEnabled() {
    return false;
  }

  public static Logger getRootLogger() {
    return INSTANCE;
  }

  public void debug(Object message) {
    //log(message, null, IStatus.INFO);
  }

  public void debug(Object message, Throwable t) {
    //log(message, t, IStatus.INFO);
  }

  public void info(Object message) {
    //log(message, null, IStatus.INFO);
  }

  public void info(Object message, Throwable t) {
    //log(message, t, IStatus.INFO);
  }

  public void warn(Object message) {
    //log(message, null, IStatus.WARNING);
  }

  public void warn(Object message, Throwable t) {
    //log(message, t, IStatus.WARNING);
  }

  public void error(Object message) {
    //log(message, null, IStatus.ERROR);
  }

  public void error(Object message, Throwable t) {
    //log(message, t, IStatus.ERROR);
  }

  public void fatal(Object message) {
    log(message, null, IStatus.ERROR);
  }

  public void fatal(Object message, Throwable t) {
    log(message, t, IStatus.ERROR);
  }

  private void log(Object message, Throwable t, int level) {
    String msg = null;
    if (message != null) {
      msg = message.toString();
    }
    ILog log = Platform.getLog(Platform.getBundle(HOST_BUNDLE));
    Status s = new Status(level, HOST_BUNDLE, msg, t);
    log.log(s);
  }
}
