/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.docx4j.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.docx4j.XlsxAdapter;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.file.FileService;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgress;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgressService;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

public class ScoutXlsxSpreadsheetAdapter
extends AbstractService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutXlsxSpreadsheetAdapter.class);
    static final String EXPORTING_LOG_MESSAGE = "exporting ";

    public File exportPage(String templateName, int startRow, int startCol, IPage page) throws ProcessingException {
        return this.exportPage(templateName, null, startRow, startCol, page, false);
    }

    public File exportPage(String templateName, Locale locale, int startRow, int startCol, IPage page) throws ProcessingException {
        return this.exportPage(templateName, locale, startRow, startCol, page, false);
    }

    public File exportPage(String templateName, int startRow, int startCol, IPage page, boolean infoRowsAtBegin) throws ProcessingException {
        return this.exportPage(templateName, null, startRow, startCol, page, infoRowsAtBegin, false);
    }

    public File exportPage(String templateName, Locale locale, int startRow, int startCol, IPage page, boolean infoRowsAtBegin) throws ProcessingException {
        return this.exportPage(templateName, locale, startRow, startCol, page, infoRowsAtBegin, false);
    }

    public File exportPage(String templateName, int startRow, int startCol, IPage page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        if (page instanceof IPageWithTable) {
            return this.exportTablePage(templateName, null, startRow, startCol, (IPageWithTable)page, infoRowsAtBegin, writeDateAtEnd);
        }
        return this.exportNodePage(templateName, null, startRow, startCol, (IPageWithNodes)page, infoRowsAtBegin, writeDateAtEnd);
    }

    public File exportPage(String templateName, Locale locale, int startRow, int startCol, IPage page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        if (page instanceof IPageWithTable) {
            return this.exportTablePage(templateName, locale, startRow, startCol, (IPageWithTable)page, infoRowsAtBegin, writeDateAtEnd);
        }
        return this.exportNodePage(templateName, locale, startRow, startCol, (IPageWithNodes)page, infoRowsAtBegin, writeDateAtEnd);
    }

    public File exportNodePage(String templateName, int startRow, int startCol, IPageWithNodes page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        return this.exportNodePage(templateName, null, startRow, startCol, page, infoRowsAtBegin, writeDateAtEnd);
    }

    public File exportNodePage(String templateName, Locale locale, int startRow, int startCol, IPageWithNodes page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        if (page == null) {
            throw new ProcessingException("No page found to export.");
        }
        String title = page.getCell().getText();
        Object[][] csv = new Object[page.getChildNodeCount() + 1][1];
        csv[0][0] = "";
        int i = 0;
        while (i < page.getChildNodeCount()) {
            String text = ((ITreeNode)page.getChildNodes().get(i)).getCell().getText();
            csv[i + 1][0] = text;
            ++i;
        }
        ArrayList<String> infoRowList = new ArrayList<String>();
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"Path", (String[])new String[0])) + ": " + page.getTree().getPathText((ITreeNode)page));
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"NumberOfRows", (String[])new String[0])) + ": " + (csv.length - 1));
        if (writeDateAtEnd) {
            infoRowList.add(String.valueOf(ScoutTexts.get((String)"ExportDate", (String[])new String[0])) + ": " + DateUtility.formatDate((Date)new Date()));
        }
        String[] infoRows = infoRowList.toArray(new String[0]);
        return this.exportCsv(templateName, locale, startRow, startCol, title, csv, infoRowsAtBegin, infoRows);
    }

    public File exportTablePage(String templateName, int startRow, int startCol, IPageWithTable<?> page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        return this.exportTablePage(templateName, null, startRow, startCol, page, infoRowsAtBegin, writeDateAtEnd);
    }

    public File exportTablePage(String templateName, Locale locale, int startRow, int startCol, IPageWithTable<?> page, boolean infoRowsAtBegin, boolean writeDateAtEnd) throws ProcessingException {
        List filterTexts;
        String[] searchTree;
        String title = page.getCell().getText();
        ITable table = page.getTable();
        Object[][] csv = this.exportTableRowsAsCSV(table);
        ArrayList<String> infoRowList = new ArrayList<String>();
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"Path", (String[])new String[0])) + ": " + page.getTree().getPathText(page));
        if (page.getSearchFilter() != null && (searchTree = page.getSearchFilter().getDisplayTexts()) != null && searchTree.length > 0) {
            infoRowList.add(ScoutTexts.get((String)"SearchConstraints", (String[])new String[0]));
            String[] stringArray = searchTree;
            int n = searchTree.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                infoRowList.add("  " + s);
                ++n2;
            }
        }
        if (table.getColumnFilterManager() != null && (filterTexts = table.getColumnFilterManager().getDisplayTexts()) != null && filterTexts.size() > 0) {
            infoRowList.add(ScoutTexts.get((String)"ColumnFilterConstraints", (String[])new String[0]));
            for (String s : filterTexts) {
                infoRowList.add("  " + s);
            }
        }
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"NumberOfRows", (String[])new String[0])) + ": " + (csv.length - 1));
        if (writeDateAtEnd) {
            infoRowList.add(String.valueOf(ScoutTexts.get((String)"ExportDate", (String[])new String[0])) + ": " + DateUtility.formatDate((Date)new Date()));
        }
        String[] infoRows = infoRowList.toArray(new String[0]);
        return this.exportCsv(templateName, locale, startRow, startCol, title, csv, infoRowsAtBegin, infoRows);
    }

    public File exportTable(String templateName, String title, ITable table) throws ProcessingException {
        return this.exportTable(templateName, null, 0, 0, title, table);
    }

    public File exportTable(String templateName, Locale locale, int startRow, int startCol, String title, ITable table) throws ProcessingException {
        Object[][] csv = this.exportTableRowsAsCSV(table);
        ArrayList<String> infoRowList = new ArrayList<String>();
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"NumberOfRows", (String[])new String[0])) + ": " + (csv.length - 1));
        infoRowList.add(String.valueOf(ScoutTexts.get((String)"ExportDate", (String[])new String[0])) + ": " + DateUtility.formatDate((Date)new Date()));
        String[] infoRows = infoRowList.toArray(new String[0]);
        return this.exportCsv(templateName, locale, startRow, startCol, title, csv, false, infoRows);
    }

    public File exportCsv(String templateName, Locale locale, int startRow, int startCol, String title, Object[][] csv, boolean infoRowsAtBegin, String[] infoRows) {
        XlsxAdapter workbook = null;
        try {
            try {
                workbook = this.prepareWorkbook(templateName, locale);
                ISimpleProgress progress = ((ISimpleProgressService)SERVICES.getService(ISimpleProgressService.class)).addProgress("Excel");
                try {
                    workbook.fillCSV(startRow, startCol, title, (String[])(infoRowsAtBegin ? infoRows : null), infoRowsAtBegin ? null : infoRows, csv, true, (IProgressMonitor)progress);
                }
                finally {
                    progress.done();
                }
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                if (desktop != null) {
                    desktop.setStatusText(ScoutTexts.get((String)"StatusExportDone", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                LOG.error(EXPORTING_LOG_MESSAGE + title, (Throwable)e);
                if (workbook != null) {
                    try {
                        File tempFile = new File(IOUtility.getTempFileName((String)".xlsx"));
                        workbook.save(tempFile);
                        return tempFile;
                    }
                    catch (Exception e2) {
                        LOG.error(EXPORTING_LOG_MESSAGE + title, (Throwable)e2);
                    }
                }
            }
        }
        finally {
            if (workbook != null) {
                try {
                    File tempFile = new File(IOUtility.getTempFileName((String)".xlsx"));
                    workbook.save(tempFile);
                    return tempFile;
                }
                catch (Exception e) {
                    LOG.error(EXPORTING_LOG_MESSAGE + title, (Throwable)e);
                }
            }
        }
        return null;
    }

    protected XlsxAdapter prepareWorkbook(String templateName, Locale locale) throws ProcessingException {
        if (StringUtility.hasText((CharSequence)templateName)) {
            FileService fs;
            File f;
            templateName = templateName.replace('\\', '/');
            String folder = null;
            if (templateName.lastIndexOf(47) != -1) {
                folder = templateName.substring(0, templateName.lastIndexOf(47));
                templateName = templateName.substring(templateName.lastIndexOf(47) + 1);
            }
            if ((f = (fs = new FileService()).getRemoteFile(folder, templateName, locale)) == null) {
                LOG.error("Could not load template: " + templateName);
            }
            return new XlsxAdapter(f);
        }
        return new XlsxAdapter();
    }

    public Object[][] exportTableRowsAsCSV(ITable table) {
        Object[][] csv = table.getSelectedRowCount() >= 2 ? table.exportTableRowsAsCSV(table.getSelectedRows(), table.getColumnSet().getVisibleColumns(), true, false, false) : table.exportTableRowsAsCSV(table.getFilteredRows(), table.getColumnSet().getVisibleColumns(), true, false, false);
        return csv;
    }
}

