/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.docx4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTCompat;
import org.docx4j.wml.CTCompatSetting;
import org.docx4j.wml.CTMarkup;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.ProofErr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.FormattingUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.docx4j.DocxComplexField;
import org.eclipse.scout.docx4j.IDocxComplexFieldProcessor;
import org.eclipse.scout.docx4j.IDocxNodeProcessor;

public class DocxAdapter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DocxAdapter.class);
    static final String WORD_SCHEMA_NAMESPACE = "http://schemas.microsoft.com/office/word";
    static final String COMPATIBILITY_MODE_NAME = "compatibilityMode";
    static final String WORD_2010_INTERNAL_VERSION = "14";
    static final String UNABLE_EXECUTE_OPERATION = "unable execute operation";
    protected static final String PRESERVE_WHITESPACE = "preserve";
    public static final String XPATH_PARAGRAPHS_WITH_DOCVARIABLE_INSTR_TEXT = "//w:p[//w:instrText[contains(.,'DOCVARIABLE')]]";
    private WordprocessingMLPackage m_package;
    private File m_file;

    protected DocxAdapter() {
    }

    public DocxAdapter(File file) throws ProcessingException {
        this(DocxAdapter.createPackageFromFile(file));
        this.m_file = file;
    }

    protected DocxAdapter(WordprocessingMLPackage wordMlPackage) {
        this.m_package = wordMlPackage;
        this.ensureCompatibilitySettings();
    }

    protected static WordprocessingMLPackage createEmptyPackage() throws ProcessingException {
        try {
            return WordprocessingMLPackage.createPackage();
        }
        catch (Docx4JException e) {
            throw new ProcessingException("Error creating an empty word package", (Throwable)e);
        }
    }

    protected static WordprocessingMLPackage createPackageFromFile(File file) throws ProcessingException {
        Docx4jProperties.getProperties().setProperty("docx4j.Log4j.Configurator.disabled", "true");
        DocxAdapter.checkFile(file);
        if (file.length() == 0L) {
            return DocxAdapter.createEmptyPackage();
        }
        try {
            return WordprocessingMLPackage.load((File)file);
        }
        catch (Docx4JException e) {
            if (!FileUtility.isZipFile((File)file)) {
                throw new VetoException("The document " + file.getName() + " is not an Office Open XML document (docx).", (Throwable)e);
            }
            throw new ProcessingException("unable to process word document", (Throwable)e);
        }
    }

    protected static void checkFile(File file) throws ProcessingException {
        if (file == null || !file.exists() || !file.canRead()) {
            throw new ProcessingException("The template file does not exist or cannot be read '" + file + "'");
        }
    }

    public WordprocessingMLPackage getPackage() {
        return this.m_package;
    }

    protected void setPackage(WordprocessingMLPackage wordMlPackage) {
        this.m_package = wordMlPackage;
    }

    protected File getFile() {
        return this.m_file;
    }

    protected void setFile(File file) {
        this.m_file = file;
    }

    public void setField(String name, String value) throws ProcessingException {
        if (this.m_package == null || StringUtility.isNullOrEmpty((CharSequence)name)) {
            return;
        }
        this.setFields(Collections.singletonMap(name, value));
    }

    public void setFields(final Map<String, String> placeholderValues) throws ProcessingException {
        if (placeholderValues == null || placeholderValues.isEmpty()) {
            return;
        }
        this.processComplexFields(XPATH_PARAGRAPHS_WITH_DOCVARIABLE_INSTR_TEXT, new IDocxComplexFieldProcessor(){

            @Override
            public boolean processField(P p, DocxComplexField complexField) {
                String name;
                StringBuilder sb = new StringBuilder();
                RPr rpr = null;
                for (Object content : complexField.getCodeContent()) {
                    if (!(content instanceof R)) continue;
                    R run = (R)content;
                    if (rpr == null) {
                        rpr = run.getRPr();
                    }
                    sb.append(DocxAdapter.this.getInstrTextValue(run));
                }
                Pattern pattern = Pattern.compile("\\s*DOCVARIABLE\\s*(.*?)\\s*(?:\\\\\\* MERGEFORMAT)?\\s*");
                Matcher m = pattern.matcher(sb.toString());
                if (m.matches() && placeholderValues.containsKey(name = m.group(1))) {
                    int insertPoint = p.getContent().indexOf(complexField.getBeginR());
                    p.getContent().removeAll(complexField.getFieldDocumentNodes());
                    DocxAdapter.this.insertTextInParagraph(new ObjectFactory(), rpr, p, insertPoint, (String)placeholderValues.get(name));
                    return true;
                }
                return false;
            }
        });
    }

    protected void insertTextInParagraph(ObjectFactory factory, RPr runProperties, P p, int index, String s) {
        this.insertTextInParagraph(factory, runProperties, p, index, s, false);
    }

    protected void insertTextInParagraph(ObjectFactory factory, RPr runProperties, P p, int index, String s, boolean enforceBreaks) {
        if (StringUtility.getLineCount((String)s) == 1) {
            p.getContent().add(index, this.createTextRun(factory, runProperties, s));
            return;
        }
        ArrayList followingSiblings = new ArrayList(p.getContent().subList(index, p.getContent().size()));
        p.getContent().removeAll(followingSiblings);
        boolean first = true;
        P currentP = p;
        String[] stringArray = StringUtility.getLines((String)s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            R run = this.createTextRun(factory, runProperties, line);
            if (first) {
                currentP.getContent().add(run);
                first = false;
            } else if (!enforceBreaks && p.getParent() instanceof ContentAccessor && (p.getParent() instanceof Body || p.getParent() instanceof Ftr || p.getParent() instanceof Hdr || p.getParent() instanceof Tc)) {
                P newP = factory.createP();
                newP.setPPr(p.getPPr());
                newP.getContent().add(run);
                List parentContent = ((ContentAccessor)p.getParent()).getContent();
                parentContent.add(parentContent.indexOf(currentP) + 1, newP);
                newP.setParent(p.getParent());
                currentP = newP;
            } else {
                if (!enforceBreaks) {
                    LOG.warn("unsupported parent element for a paragraph: " + p.getParent());
                }
                Br br = factory.createBr();
                run.getContent().add(0, br);
                currentP.getContent().add(run);
            }
            ++n2;
        }
        currentP.getContent().addAll(followingSiblings);
    }

    protected R createTextRun(ObjectFactory factory, RPr runProperties, String s) {
        R run = factory.createR();
        run.setRPr(runProperties);
        String[] parts = StringUtility.split((String)StringUtility.nvl((Object)s, (String)""), (String)"\\t");
        if (parts.length == 0) {
            parts = new String[]{""};
        }
        boolean first = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String textPart = stringArray[n2];
            if (!first) {
                first = true;
            } else {
                R.Tab tab = factory.createRTab();
                run.getContent().add(factory.createRTab(tab));
            }
            Text text = factory.createText();
            text.setValue(textPart);
            text.setSpace(PRESERVE_WHITESPACE);
            run.getContent().add(factory.createRT(text));
            ++n2;
        }
        return run;
    }

    protected STFldCharType getFldCharType(R r) {
        FldChar fldChar = this.getFldChar(r);
        if (fldChar == null) {
            return null;
        }
        return fldChar.getFldCharType();
    }

    protected FldChar getFldChar(R r) {
        if (r == null || r.getContent() == null) {
            return null;
        }
        for (Object o : r.getContent()) {
            if (!((o = XmlUtils.unwrap(o)) instanceof FldChar)) continue;
            return (FldChar)o;
        }
        return null;
    }

    protected String getInstrTextValue(R r) {
        if (r == null || r.getContent() == null) {
            return "";
        }
        for (Object o : r.getContent()) {
            if (!(o instanceof JAXBElement) || !CompareUtility.equals((Object)((JAXBElement)o).getName().getLocalPart(), (Object)"instrText") || !((o = XmlUtils.unwrap(o)) instanceof Text)) continue;
            return ((Text)o).getValue();
        }
        return "";
    }

    protected Tbl getTableByIndex(int ... index) throws ProcessingException {
        return this.findTableByIndex(index);
    }

    protected Tbl getTableByBookmark(String bookmark) throws ProcessingException {
        try {
            return this.findTableByBookmark(bookmark);
        }
        catch (JAXBException e) {
            throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
        }
    }

    public void deleteTableByBookmark(String bookmark) throws ProcessingException {
        boolean changed = false;
        try {
            Tbl tbl = this.findTableByBookmark(bookmark);
            if (tbl == null) {
                return;
            }
            try {
                Object parent = XmlUtils.unwrap((Object)tbl.getParent());
                if (parent instanceof ContentAccessor) {
                    changed = ((ContentAccessor)parent).getContent().remove(tbl);
                }
                if (!changed) {
                    Iterator it = tbl.getContent().iterator();
                    while (it.hasNext()) {
                        Object next = XmlUtils.unwrap(it.next());
                        if (!(next instanceof Tr)) continue;
                        it.remove();
                    }
                }
            }
            catch (JAXBException e) {
                throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
            }
        }
        finally {
            if (changed) {
                this.applyChangesToJaxbElements();
            }
        }
    }

    public void fillTable(int tableIndex, int startRow, int startCol, Object[][] data) throws ProcessingException {
        this.fillTable(this.getTableByIndex(tableIndex), startRow, startCol, data);
    }

    public void fillTable(String tableBookmark, int startRow, int startCol, Object[][] data) throws ProcessingException {
        this.fillTable(this.getTableByBookmark(tableBookmark), startRow, startCol, data);
    }

    protected void fillTable(Tbl table, int startRow, int startCol, Object[][] data) throws ProcessingException {
        if (table == null) {
            throw new ProcessingException("Table is not set");
        }
        try {
            List<Tr> rows = this.getRowsOfTable(table);
            Tr templateRow = rows.get(rows.size() - 1);
            this.removeMarkup(templateRow);
            while (startRow + data.length > this.getRowsOfTable(table).size()) {
                Tr rowCopy = (Tr)XmlUtils.deepCopy((Object)templateRow);
                table.getContent().add(rowCopy);
            }
            Object[][] objectArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] array = objectArray[n2];
                int rowCol = startCol;
                Tr tr = this.getRowOfTable(table, startRow);
                if (tr == null) {
                    return;
                }
                Object[] objectArray2 = array;
                int n3 = array.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object o = objectArray2[n4];
                    Tc tc = this.getColumnOfRow(tr, rowCol);
                    this.setTextInColumn(tc, StringUtility.nvl((Object)FormattingUtility.formatObject((Object)o), (String)""));
                    ++rowCol;
                    ++n4;
                }
                ++startRow;
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
        }
    }

    protected List<Tr> getRowsOfTable(Tbl table) {
        ArrayList<Tr> rows = new ArrayList<Tr>();
        for (Object tableContent : table.getContent()) {
            if (!(tableContent instanceof Tr)) continue;
            rows.add((Tr)tableContent);
        }
        return rows;
    }

    protected Tr getRowOfTable(Tbl table, int index) {
        int i = 0;
        for (Object tableContent : table.getContent()) {
            if (!(tableContent instanceof Tr)) continue;
            if (i == index) {
                return (Tr)tableContent;
            }
            ++i;
        }
        return null;
    }

    protected Tc getColumnOfRow(Tr row, int index) {
        int i = 0;
        for (Object rowContent : row.getContent()) {
            if (!(rowContent instanceof JAXBElement) || !(((JAXBElement)rowContent).getValue() instanceof Tc)) continue;
            if (i == index) {
                return (Tc)((JAXBElement)rowContent).getValue();
            }
            ++i;
        }
        return null;
    }

    protected JAXBElement<?> getJaxbelementOfColumnOfRow(Tr row, int index) {
        int i = 0;
        for (Object rowContent : row.getContent()) {
            if (!(rowContent instanceof JAXBElement) || !(((JAXBElement)rowContent).getValue() instanceof Tc)) continue;
            if (i == index) {
                return (JAXBElement)rowContent;
            }
            ++i;
        }
        return null;
    }

    public void setTextInColumn(Tc column, String value) {
        if (column == null) {
            return;
        }
        for (Object columnP : column.getContent()) {
            if (!(columnP instanceof P)) continue;
            P p = (P)columnP;
            for (Object pRun : p.getContent()) {
                if (!(pRun instanceof R)) continue;
                R r = (R)pRun;
                for (Object element : r.getContent()) {
                    Object t = XmlUtils.unwrap(element);
                    if (!(t instanceof Text)) continue;
                    ((Text)t).setValue(value);
                    return;
                }
            }
            ParaRPr pRpr = p.getPPr().getRPr();
            this.insertTextInParagraph(new ObjectFactory(), this.createRprFromParaRpr(pRpr), p, 0, value);
            return;
        }
    }

    protected RPr createRprFromParaRpr(ParaRPr pRpr) {
        ObjectFactory factory = new ObjectFactory();
        RPr rpr = factory.createRPr();
        rpr.setB(pRpr.getB());
        rpr.setBCs(pRpr.getBCs());
        rpr.setBdr(pRpr.getBdr());
        rpr.setCaps(pRpr.getCaps());
        rpr.setColor(pRpr.getColor());
        rpr.setCs(pRpr.getCs());
        rpr.setDstrike(pRpr.getDstrike());
        rpr.setEastAsianLayout(pRpr.getEastAsianLayout());
        rpr.setEffect(pRpr.getEffect());
        rpr.setEm(pRpr.getEm());
        rpr.setEmboss(pRpr.getEmboss());
        rpr.setFitText(pRpr.getFitText());
        rpr.setHighlight(pRpr.getHighlight());
        rpr.setI(pRpr.getI());
        rpr.setICs(pRpr.getICs());
        rpr.setImprint(pRpr.getImprint());
        rpr.setKern(pRpr.getKern());
        rpr.setLang(pRpr.getLang());
        rpr.setNoProof(pRpr.getNoProof());
        rpr.setOMath(pRpr.getOMath());
        rpr.setOutline(pRpr.getOutline());
        rpr.setPosition(pRpr.getPosition());
        rpr.setRFonts(pRpr.getRFonts());
        rpr.setRStyle(pRpr.getRStyle());
        rpr.setRtl(pRpr.getRtl());
        rpr.setShadow(pRpr.getShadow());
        rpr.setShd(pRpr.getShd());
        rpr.setSmallCaps(pRpr.getSmallCaps());
        rpr.setSnapToGrid(pRpr.getSnapToGrid());
        rpr.setSpacing(pRpr.getSpacing());
        rpr.setSpecVanish(pRpr.getSpecVanish());
        rpr.setStrike(pRpr.getStrike());
        rpr.setSz(pRpr.getSz());
        rpr.setSzCs(pRpr.getSzCs());
        rpr.setU(pRpr.getU());
        rpr.setVanish(pRpr.getVanish());
        rpr.setVertAlign(pRpr.getVertAlign());
        rpr.setW(pRpr.getW());
        rpr.setWebHidden(pRpr.getWebHidden());
        return rpr;
    }

    public File save() throws ProcessingException {
        if (this.m_package == null) {
            return null;
        }
        if (this.m_file == null) {
            throw new ProcessingException("File is not set. Adapter was not created by opening a file. Use saveAs instead.");
        }
        try {
            this.m_package.save(this.m_file);
            return this.m_file;
        }
        catch (Exception e) {
            throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
        }
    }

    public File saveAs(String filename) throws ProcessingException {
        if (this.m_package == null) {
            return null;
        }
        try {
            File file = new File(filename);
            this.m_package.save(file);
            return file;
        }
        catch (Exception e) {
            throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
        }
    }

    protected Tbl findTableByIndex(int index) throws ProcessingException {
        return this.findTableByIndex(new int[]{index});
    }

    protected Tbl findTableByIndex(int[] indices) throws ProcessingException {
        List objects;
        block6: {
            if (this.m_package == null || indices == null || indices.length == 0) {
                return null;
            }
            String xpath = "//w:tbl";
            objects = this.getMainDocumentPart().getJAXBNodesViaXPath("//w:tbl", false);
            if (objects != null && objects.size() != 0) break block6;
            return null;
        }
        try {
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                Object tbl;
                int index = nArray[n2];
                if (objects.size() > index && objects.get(index) instanceof JAXBElement && (tbl = ((JAXBElement)objects.get(index)).getValue()) instanceof Tbl) {
                    return (Tbl)tbl;
                }
                ++n2;
            }
        }
        catch (JAXBException e) {
            throw new ProcessingException(UNABLE_EXECUTE_OPERATION, (Throwable)e);
        }
        return null;
    }

    protected Tbl findTableByBookmark(String name) throws JAXBException {
        if (this.m_package == null) {
            return null;
        }
        String xpath = "//w:bookmarkStart[@w:name='" + name + "']/../../../..";
        List objects = this.getMainDocumentPart().getJAXBNodesViaXPath(xpath, false);
        if (objects != null && objects.size() > 0) {
            Object tbl = XmlUtils.unwrap(objects.get(0));
            if (tbl instanceof Tbl) {
                return (Tbl)tbl;
            }
            LOG.warn("Found possible table bookmark " + name + " but it is not a table");
        }
        return null;
    }

    protected MainDocumentPart getMainDocumentPart() {
        if (this.m_package == null) {
            return null;
        }
        return this.m_package.getMainDocumentPart();
    }

    public boolean processDocumentParts(String xpath, IDocxNodeProcessor processor) throws ProcessingException {
        boolean changed = false;
        try {
            try {
                for (HeaderPart headerPart : this.getAllHeaderParts()) {
                    if (headerPart.getBinder() == null) continue;
                    for (Object node : headerPart.getJAXBNodesViaXPath(xpath, false)) {
                        changed |= processor.process(node);
                    }
                }
                for (Object node : this.getMainDocumentPart().getJAXBNodesViaXPath(xpath, false)) {
                    changed |= processor.process(node);
                }
                for (FooterPart footerPart : this.getAllFooterParts()) {
                    if (footerPart.getBinder() == null) continue;
                    for (Object node : footerPart.getJAXBNodesViaXPath(xpath, false)) {
                        changed |= processor.process(node);
                    }
                }
            }
            catch (JAXBException e) {
                throw new ProcessingException("Error while processing document parts", (Throwable)e);
            }
        }
        finally {
            if (changed) {
                this.applyChangesToJaxbElements();
            }
        }
        return changed;
    }

    public boolean processComplexFields(String paragraphXpath, final IDocxComplexFieldProcessor fieldProcessor) throws ProcessingException {
        return this.processDocumentParts(paragraphXpath, new IDocxNodeProcessor(){

            @Override
            public boolean process(Object documentNode) throws JAXBException, ProcessingException {
                boolean changed = false;
                Object unwrappedDcoumentNode = XmlUtils.unwrap((Object)documentNode);
                if (unwrappedDcoumentNode == null) {
                    throw new ProcessingException("document node must not be null");
                }
                if (!(unwrappedDcoumentNode instanceof P)) {
                    throw new ProcessingException("Only paragraphs are supported for processing complex fields. But given document node has type [" + unwrappedDcoumentNode.getClass() + "]");
                }
                P p = (P)unwrappedDcoumentNode;
                boolean withinFldCharSection = false;
                boolean withinFldCharSeparate = false;
                DocxComplexField complexField = new DocxComplexField();
                for (Object content : new ArrayList(p.getContent())) {
                    Object unwrappedContent = XmlUtils.unwrap(content);
                    if (unwrappedContent instanceof R) {
                        R run = (R)unwrappedContent;
                        STFldCharType fldCharType = DocxAdapter.this.getFldCharType(run);
                        if (fldCharType == STFldCharType.BEGIN) {
                            if (withinFldCharSection) {
                                throw new ProcessingException("invalid document: second fldChar start within fldChar start");
                            }
                            withinFldCharSection = true;
                            complexField.setBeginR(run);
                            continue;
                        }
                        if (fldCharType == STFldCharType.SEPARATE) {
                            if (!withinFldCharSection) {
                                throw new ProcessingException("invalid document: fldChar separate without fldChar start");
                            }
                            if (withinFldCharSeparate) {
                                throw new ProcessingException("invalid document: second fldChar separate within same fldChar start");
                            }
                            withinFldCharSeparate = true;
                            complexField.setSeparateR(run);
                            continue;
                        }
                        if (fldCharType == STFldCharType.END) {
                            if (!withinFldCharSection) {
                                throw new ProcessingException("invalid document: fldChar end without fldChar start");
                            }
                            withinFldCharSection = false;
                            complexField.setEndR(run);
                            changed |= fieldProcessor.processField(p, complexField);
                            complexField = new DocxComplexField();
                            withinFldCharSection = false;
                            withinFldCharSeparate = false;
                            continue;
                        }
                    }
                    if (withinFldCharSeparate) {
                        complexField.addDefaultValueContent(content);
                        continue;
                    }
                    if (!withinFldCharSection) continue;
                    complexField.addCodeContent(content);
                }
                if (withinFldCharSection) {
                    throw new ProcessingException("invalid document: fldChar start without fldChar end");
                }
                return changed;
            }
        });
    }

    protected Set<HeaderPart> getAllHeaderParts() {
        HashSet<HeaderPart> headers = new HashSet<HeaderPart>();
        List sections = this.getPackage().getDocumentModel().getSections();
        for (SectionWrapper section : sections) {
            HeaderFooterPolicy hfp = section.getHeaderFooterPolicy();
            if (hfp == null) continue;
            if (hfp.getDefaultHeader() != null) {
                headers.add(hfp.getDefaultHeader());
            }
            if (hfp.getFirstHeader() != null) {
                headers.add(hfp.getFirstHeader());
            }
            if (hfp.getEvenHeader() == null) continue;
            headers.add(hfp.getEvenHeader());
        }
        return headers;
    }

    protected Set<FooterPart> getAllFooterParts() {
        HashSet<FooterPart> footers = new HashSet<FooterPart>();
        for (SectionWrapper section : this.getPackage().getDocumentModel().getSections()) {
            HeaderFooterPolicy hfp = section.getHeaderFooterPolicy();
            if (hfp == null) continue;
            if (hfp.getDefaultFooter() != null) {
                footers.add(hfp.getDefaultFooter());
            }
            if (hfp.getFirstFooter() != null) {
                footers.add(hfp.getFirstFooter());
            }
            if (hfp.getEvenFooter() == null) continue;
            footers.add(hfp.getEvenFooter());
        }
        return footers;
    }

    protected final void ensureCompatibilitySettings() {
        try {
            CTCompat compat;
            CTSettings settings;
            ObjectFactory factory = new ObjectFactory();
            DocumentSettingsPart dsp = this.getMainDocumentPart().getDocumentSettingsPart();
            if (dsp == null) {
                dsp = new DocumentSettingsPart();
                this.getMainDocumentPart().addTargetPart((Part)dsp);
            }
            if ((settings = (CTSettings)dsp.getJaxbElement()) == null) {
                settings = factory.createCTSettings();
                dsp.setJaxbElement((Object)settings);
            }
            if ((compat = settings.getCompat()) == null) {
                compat = new CTCompat();
                settings.setCompat(compat);
            }
            for (CTCompatSetting cs : compat.getCompatSetting()) {
                if (!WORD_SCHEMA_NAMESPACE.equals(cs.getUri()) || !COMPATIBILITY_MODE_NAME.equals(cs.getName())) continue;
                return;
            }
            CTCompatSetting compatSetting = new CTCompatSetting();
            compatSetting.setName(COMPATIBILITY_MODE_NAME);
            compatSetting.setUri(WORD_SCHEMA_NAMESPACE);
            compatSetting.setVal(WORD_2010_INTERNAL_VERSION);
            compat.getCompatSetting().add(compatSetting);
        }
        catch (InvalidFormatException e) {
            LOG.info("error adding compatibility settings", (Throwable)e);
        }
    }

    protected void applyChangesToJaxbElements() {
        try {
            this.m_package = DocxAdapter.applyChangesToJaxbElements(this.m_package);
        }
        catch (Exception e) {
            LOG.warn("Exception while applying changes to JAXB elements", (Throwable)e);
        }
    }

    protected void removeMarkup(Object o) {
        if (o == null) {
            return;
        }
        Object unwrapped = XmlUtils.unwrap((Object)o);
        if (unwrapped instanceof ContentAccessor) {
            ContentAccessor ca = (ContentAccessor)unwrapped;
            if (ca.getContent() == null) {
                return;
            }
            Iterator it = ca.getContent().iterator();
            while (it.hasNext()) {
                Object next = XmlUtils.unwrap(it.next());
                if (next instanceof CTMarkup || next instanceof ProofErr) {
                    it.remove();
                    continue;
                }
                this.removeMarkup(next);
            }
        }
    }

    public static WordprocessingMLPackage applyChangesToJaxbElements(WordprocessingMLPackage pkg) throws Docx4JException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)pkg);
        saver.save((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return WordprocessingMLPackage.load((InputStream)in);
    }
}

