package org.eclipse.scout.sdk.docx4j.internal.model;

import java.util.HashMap;
import java.util.TreeMap;

import org.eclipse.scout.nls.sdk.model.util.Language;

public class NlsLine {

  private String m_key;
  private final HashMap<Language, String> m_translations;
  private final TreeMap<String, String> m_usages;

  public NlsLine() {
    this(null);
  }

  public NlsLine(String key) {
    m_key = key;
    m_translations = new HashMap<Language, String>();
    m_usages = new TreeMap<String, String>();
  }

  public void addTranslation(Language language, String translation) {
    m_translations.put(language, translation);
  }

  public String getTranslation(Language language) {
    return m_translations.get(language);
  }

  public String getKey() {
    return m_key;
  }

  public void setKey(String newKey) {
    m_key = newKey;
  }

  public HashMap<Language, String> getTranslations() {
    return m_translations;
  }

  public void addUsage(String usage) {
    m_usages.put(usage.toLowerCase(), usage);
  }

  public String[] getUsages() {
    return m_usages.values().toArray(new String[m_usages.size()]);
  }

  public String getUsagesAsString() {
    StringBuilder b = new StringBuilder();
    String[] usages = getUsages();
    for (int u = 0; u < usages.length; u++) {
      b.append(usages[u]);
      if (u < usages.length - 1) {
        b.append("\n");
      }
    }
    return b.toString();
  }
}
