/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.docx4j.internal.ui.wizad.nls;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.ui.fields.FileChooserField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class XlsxImportWizardPage
extends WizardPage {
    private Composite m_rootPane;
    private FileChooserField m_fileChooserField;
    private String m_fileUrl = null;

    protected XlsxImportWizardPage() {
        super(XlsxImportWizardPage.class.getName());
        this.setTitle("Export NLS Entries");
        this.setDescription("Exports the NLS entries to a *.xlsx format.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.m_rootPane = new Composite(parent, 0);
        this.m_fileChooserField = new FileChooserField(this.m_rootPane, "Select .xlsx file to import.");
        this.m_fileChooserField.setButtonText("Browse");
        String extension = ".xlsx";
        this.m_fileChooserField.setExtendsionFilter(new String[]{"*.xlsx"});
        this.m_fileChooserField.setLabelText("XLSX-File:");
        this.m_fileChooserField.addInputChangedListener(24, (IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                XlsxImportWizardPage.this.m_fileUrl = input;
                XlsxImportWizardPage.this.setPageComplete(StringUtility.hasText((String)XlsxImportWizardPage.this.m_fileUrl) && IOUtility.fileExists((String)XlsxImportWizardPage.this.m_fileUrl));
            }
        });
        this.m_fileChooserField.addInputChangedListener(16, (IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                if (StringUtility.hasText((String)input) && !input.endsWith(".xlsx")) {
                    XlsxImportWizardPage.this.m_fileChooserField.setValue(String.valueOf(input) + ".xlsx");
                }
            }
        });
        this.m_rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_fileChooserField.setLayoutData((Object)new GridData(768));
    }

    public Control getControl() {
        return this.m_rootPane;
    }

    public void setVisible(boolean visible) {
        if (this.m_rootPane != null && !this.m_rootPane.isDisposed()) {
            this.m_rootPane.setVisible(visible);
        }
    }

    public String getFileUrl() {
        return this.m_fileUrl;
    }
}

