package org.eclipse.scout.sdk.docx4j.internal.ui.wizad.nls;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.ui.fields.FileChooserField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class XlsxImportWizardPage extends WizardPage {

  // ui fields
  private Composite m_rootPane;
  private FileChooserField m_fileChooserField;

  // members
  private String m_fileUrl = null;

  protected XlsxImportWizardPage() {
    super(XlsxImportWizardPage.class.getName());
    setTitle("Export NLS Entries");
    setDescription("Exports the NLS entries to a *.xlsx format.");
    setPageComplete(false);
  }

  @Override
  public void createControl(Composite parent) {
    m_rootPane = new Composite(parent, SWT.NONE);
    m_fileChooserField = new FileChooserField(m_rootPane, "Select .xlsx file to import.");
    m_fileChooserField.setButtonText("Browse");
    final String extension = ".xlsx";
    m_fileChooserField.setExtendsionFilter(new String[]{"*" + extension});
    m_fileChooserField.setLabelText("XLSX-File:");
    m_fileChooserField.addInputChangedListener(SWT.Modify,
        new IInputChangedListener<String>() {
          @Override
          public void inputChanged(String input) {
            m_fileUrl = input;
            setPageComplete(StringUtility.hasText(m_fileUrl) && IOUtility.fileExists(m_fileUrl));
          }
        });
    m_fileChooserField.addInputChangedListener(SWT.FocusOut,
        new IInputChangedListener<String>() {
          @Override
          public void inputChanged(String input) {
            if (StringUtility.hasText(input) && !input.endsWith(extension)) {
              m_fileChooserField.setValue(input + extension);
            }
          }
        });

    m_rootPane.setLayout(new GridLayout(1, true));
    m_fileChooserField.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
  }

  @Override
  public Control getControl() {
    return m_rootPane;
  }

  @Override
  public void setVisible(boolean visible) {
    if (m_rootPane != null && !m_rootPane.isDisposed()) {
      m_rootPane.setVisible(visible);
    }
  }

  public String getFileUrl() {
    return m_fileUrl;
  }
}
