/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.cloud.cachestore.redis;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.cache.AbstractCacheStoreService;
import org.osgi.framework.ServiceRegistration;
import redis.clients.jedis.Jedis;

public class RedisCacheService
extends AbstractCacheStoreService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RedisCacheService.class);
    private Jedis jedis;
    private String m_host;
    private int m_port;
    private String m_password;
    private boolean m_auth;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.setClient();
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public void setPassword(String m_password) {
        this.m_password = m_password;
    }

    public void setAuth(boolean m_auth) {
        this.m_auth = m_auth;
    }

    public Object getClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        return this.getAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key);
    }

    public void setClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Object value) {
        this.setAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, value, this.getExpiration());
    }

    public void setClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Object value, Integer expiration) {
        this.setAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, value, expiration);
    }

    public void removeClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        this.removeAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key);
    }

    public void setGlobalAttribute(String key, Object value) {
        this.setAttribute(key, value, this.getExpiration());
    }

    public void setGlobalAttribute(String key, Object value, Integer expiration) {
        this.setAttribute(key, value, expiration);
    }

    public Object getGlobalAttribute(String key) {
        return this.getAttribute(key);
    }

    public Object getGlobalAttributeAndTouch(String key, Integer expiration) {
        Object o = this.getAttribute(key);
        this.touchAttribute(key, expiration);
        return o;
    }

    public void removeGlobalAttribute(String key) {
        this.removeAttribute(key);
    }

    public Object getClientAttributeAndTouch(HttpServletRequest req, HttpServletResponse res, String key, Integer expiration) {
        return this.getAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, expiration);
    }

    public void touchClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Integer expiration) {
        this.touchAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, expiration);
    }

    private void touchAttribute(String key, Integer expiration) {
        this.checkConnection();
        this.jedis.expire(key, expiration.intValue());
    }

    public void touchGlobalAttribute(String key, Integer expiration) {
        this.checkConnection();
        this.jedis.expire(key, expiration.intValue());
    }

    private void setAttribute(String key, Object value, Integer expiration) {
        this.checkConnection();
        try {
            this.jedis.set(key, this.serializedString(value));
        }
        catch (ProcessingException e) {
            LOG.error("Unable to serialize value", (Throwable)e);
        }
        this.jedis.expire(key, expiration.intValue());
    }

    private void removeAttribute(String key) {
        this.checkConnection();
        this.jedis.del(new String[]{key});
    }

    private Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    private Object getAttribute(String key, Integer expiration) {
        String str = null;
        this.checkConnection();
        str = this.jedis.get(key);
        if (expiration != null) {
            this.jedis.expire(key, expiration.intValue());
        }
        if (str != null) {
            return this.deserialize(str);
        }
        return null;
    }

    public Object getClientAttributeAndTouch(HttpServletRequest req, HttpServletResponse res, String key) {
        return this.getClientAttributeAndTouch(req, res, key, this.getExpiration());
    }

    public void touchClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        this.touchClientAttribute(req, res, key, this.getExpiration());
    }

    protected void setClient() {
        try {
            this.jedis = new Jedis(this.m_host, this.m_port);
            if (this.m_auth && !StringUtility.isNullOrEmpty((String)this.m_password)) {
                this.jedis.auth(this.m_password);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to connet to Redis", (Throwable)e);
        }
    }

    protected void checkConnection() {
        if (!this.jedis.isConnected()) {
            this.setClient();
        }
    }
}

