/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.cloud.cachestore;

import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CASValue;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.cache.AbstractCacheStoreService;
import org.osgi.framework.ServiceRegistration;

public class MemcachedCacheService
extends AbstractCacheStoreService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MemcachedCacheService.class);
    private MemcachedClient client;
    private String m_url;
    private Integer m_port;
    private String m_username;
    private String m_password;
    private boolean m_auth;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.setClient();
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setUsername(String m_username) {
        this.m_username = m_username;
    }

    public void setPassword(String m_password) {
        this.m_password = m_password;
    }

    public void setAuth(boolean m_auth) {
        this.m_auth = m_auth;
    }

    public Object getClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        return this.getAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key);
    }

    public void setClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Object value) {
        this.setAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, value, this.getExpiration());
    }

    public void setClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Object value, Integer expiration) {
        this.setAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, value, expiration);
    }

    public void removeClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        this.removeAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key);
    }

    public void setGlobalAttribute(String key, Object value) {
        this.setAttribute(key, value, this.getExpiration());
    }

    public void setGlobalAttribute(String key, Object value, Integer expiration) {
        this.setAttribute(key, value, expiration);
    }

    public Object getGlobalAttribute(String key) {
        return this.getAttribute(key);
    }

    public Object getGlobalAttributeAndTouch(String key, Integer expiration) {
        Object o = this.getAttribute(key);
        this.touchAttribute(key, expiration);
        return o;
    }

    public void removeGlobalAttribute(String key) {
        this.removeAttribute(key);
    }

    public Object getClientAttributeAndTouch(HttpServletRequest req, HttpServletResponse res, String key, Integer expiration) {
        return this.getAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, expiration);
    }

    public void touchClientAttribute(HttpServletRequest req, HttpServletResponse res, String key, Integer expiration) {
        this.touchAttribute(String.valueOf(this.getSessionId(req, res)) + "_" + key, expiration);
    }

    private void touchAttribute(String key, Integer expiration) {
        this.client.touch(key, expiration.intValue());
    }

    public void touchGlobalAttribute(String key, Integer expiration) {
        this.client.touch(key, expiration.intValue());
    }

    private void setAttribute(String key, Object value, Integer expiration) {
        try {
            this.client.add(key, expiration.intValue(), (Object)this.serializedString(value));
        }
        catch (ProcessingException e) {
            LOG.error("Unable to serialize vaue", (Throwable)e);
        }
    }

    private void removeAttribute(String key) {
        this.client.delete(key);
    }

    private Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    private Object getAttribute(String key, Integer expiration) {
        String str = null;
        if (expiration == null) {
            str = (String)this.client.get(key);
        } else {
            CASValue cas = this.client.getAndTouch(key, expiration.intValue());
            if (cas != null) {
                str = (String)cas.getValue();
            }
        }
        if (str != null) {
            return this.deserialize(str);
        }
        return null;
    }

    public Object getClientAttributeAndTouch(HttpServletRequest req, HttpServletResponse res, String key) {
        return this.getClientAttributeAndTouch(req, res, key, this.getExpiration());
    }

    public void touchClientAttribute(HttpServletRequest req, HttpServletResponse res, String key) {
        this.touchClientAttribute(req, res, key, this.getExpiration());
    }

    private void setClient() {
        try {
            ConnectionFactory c;
            if (this.m_auth && this.m_username != null && this.m_password != null) {
                LOG.info("Using authentication with memcache");
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(this.m_username, this.m_password));
                c = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(ad).build();
            } else {
                LOG.info("Using no authentication with memcache");
                c = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build();
            }
            this.client = new MemcachedClient(c, AddrUtil.getAddresses((String)(String.valueOf(this.m_url) + ":" + this.m_port)));
        }
        catch (Exception e) {
            LOG.error("Couldn't create a connection to memcached", (Throwable)e);
        }
    }
}

