/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.redis;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.cache.AbstractGlobalServerCacheService;
import org.osgi.framework.ServiceRegistration;
import redis.clients.jedis.Jedis;

public class RedisCacheService
extends AbstractGlobalServerCacheService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RedisCacheService.class);
    private static final int MILLISECONDS_IN_SECONDS = 1000;
    private static final int DEFAULT_PORT = 6379;
    private Jedis m_jedis;
    private String m_host;
    private int m_port = 6379;
    private String m_password;
    private boolean m_authEnabled = false;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.setClient();
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setAuth(boolean enabled) {
        this.m_authEnabled = enabled;
    }

    public void put(String key, Object value, Long expiration) {
        this.checkConnection();
        try {
            this.m_jedis.set(key, this.serializedString(value));
        }
        catch (ProcessingException e) {
            LOG.error("Unable to serialize value", (Throwable)e);
        }
        this.m_jedis.expire(key, this.toSeconds(expiration).intValue());
    }

    public Object get(String key) {
        this.checkConnection();
        return this.deserialize(this.m_jedis.get(key));
    }

    public Object getAndTouch(String key, Long expiration) {
        this.checkConnection();
        String str = this.m_jedis.get(key);
        if (expiration != null) {
            this.m_jedis.expire(key, this.toSeconds(expiration).intValue());
        }
        if (str != null) {
            return this.deserialize(str);
        }
        return null;
    }

    public void remove(String key) {
        this.checkConnection();
        this.m_jedis.del(new String[]{key});
    }

    public void touch(String key, Long expiration) {
        this.checkConnection();
        this.m_jedis.expire(key, this.toSeconds(expiration).intValue());
    }

    private Integer toSeconds(Long milliseconds) {
        Long ms = milliseconds / 1000L;
        return ms.intValue();
    }

    protected void setClient() {
        try {
            this.m_jedis = new Jedis(this.m_host, this.m_port);
            if (this.m_authEnabled && !StringUtility.isNullOrEmpty((CharSequence)this.m_password)) {
                this.m_jedis.auth(this.m_password);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to connet to Redis", (Throwable)e);
        }
    }

    protected void checkConnection() {
        if (!this.m_jedis.isConnected()) {
            this.setClient();
        }
    }
}

