/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.memcached;

import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.cache.AbstractGlobalServerCacheService;
import org.osgi.framework.ServiceRegistration;

public class MemcachedCacheService
extends AbstractGlobalServerCacheService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MemcachedCacheService.class);
    private static final int DEFAULT_PORT = 11211;
    private static final int MILLISECONDS_IN_SECONDS = 1000;
    private MemcachedClientIF m_client;
    private String m_url;
    private Integer m_port = 11211;
    private String m_username;
    private String m_password;
    private boolean m_authEnabled;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.m_client = this.createMemcachedClient();
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setAuth(boolean enabled) {
        this.m_authEnabled = enabled;
    }

    public void put(String key, Object value, Long expiration) {
        try {
            this.m_client.set(key, this.toSeconds(expiration).intValue(), (Object)this.serializedString(value));
        }
        catch (ProcessingException e) {
            LOG.error("Unable to serialize vaue", (Throwable)e);
        }
    }

    public Object getAndTouch(String key, Long expiration) {
        Object v = this.m_client.get(key);
        if (v != null) {
            this.m_client.touch(key, this.toSeconds(expiration).intValue());
            return this.deserialize((String)v);
        }
        return null;
    }

    public Object get(String key) {
        return this.deserialize((String)this.m_client.get(key));
    }

    public void remove(String key) {
        this.m_client.delete(key);
    }

    public void touch(String key, Long expiration) {
        this.m_client.touch(key, this.toSeconds(expiration).intValue());
    }

    private Integer toSeconds(Long milliseconds) {
        Long ms = milliseconds / 1000L;
        return ms.intValue();
    }

    protected MemcachedClientIF createMemcachedClient() {
        try {
            ConnectionFactory c;
            if (this.m_authEnabled && this.m_username != null && this.m_password != null) {
                LOG.info("Using authentication with memcache");
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(this.m_username, this.m_password));
                c = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(ad).build();
            } else {
                LOG.info("Using no authentication with memcache");
                c = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build();
            }
            if (this.m_url != null) {
                return new MemcachedClient(c, AddrUtil.getAddresses((String)(String.valueOf(this.m_url) + ":" + this.m_port)));
            }
            String configIniSuggestion = "Add \norg.eclipse.scout.rt.server.memcached.MemcachedCacheService#url=<URL>\norg.eclipse.scout.rt.server.memcached.MemcachedCacheService#port=<PORT>\nto your config.ini file!";
            LOG.error("url not defined in MemcachedCacheService.\n" + configIniSuggestion);
        }
        catch (Exception e) {
            LOG.error("Couldn't create a connection to memcached", (Throwable)e);
        }
        return null;
    }
}

