/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clustersync.jms;

import java.io.IOException;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IPubSubMessageListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IPubSubMessageService;
import org.eclipse.scout.service.AbstractService;

public class JMSPubSubMessageService
extends AbstractService
implements IPubSubMessageService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JMSPubSubMessageService.class);
    private IObjectSerializer m_objectSerializer;
    private static final int DEFAULT_PORT = 61616;
    private String m_topicName = "scout.messages";
    private String m_initialContextFactory = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
    private String m_host;
    private Integer m_port = 61616;
    private String m_username;
    private String m_password;
    private boolean m_auth;
    private TopicConnectionFactory m_fact = null;
    private Topic m_topic = null;
    private TopicConnection m_connection;
    private TopicSession m_session;
    private TopicSubscriber m_subscriber;
    private TopicPublisher m_publisher;
    private boolean m_checkForMessages;
    private IPubSubMessageListener m_listener;

    public void setHost(String host) {
        this.m_host = host;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setAuth(boolean auth) {
        this.m_auth = auth;
    }

    public boolean subscribe(String queueName) {
        this.m_objectSerializer = SerializationUtility.createObjectSerializer();
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", this.m_initialContextFactory);
        properties.put("connectionfactory.QueueConnectionFactory", "tcp://" + this.m_host + ":" + this.m_port);
        properties.put("topic." + this.m_topicName, this.m_topicName);
        try {
            LOG.info("Initialising JNDI... ");
            InitialDirContext ctx = new InitialDirContext(properties);
            LOG.info("Obtaining TCF from JNDI... ");
            this.m_fact = (TopicConnectionFactory)ctx.lookup("QueueConnectionFactory");
            LOG.info("Obtaining topic T from JNDI... ");
            this.m_topic = (Topic)ctx.lookup(this.m_topicName);
            this.m_connection = this.createConnection();
            this.m_connection.start();
            this.m_session = this.m_connection.createTopicSession(false, 1);
            Topic t = this.m_session.createTopic(this.m_topicName);
            this.m_publisher = this.m_session.createPublisher(t);
            this.m_subscriber = this.m_session.createSubscriber(t);
            this.m_subscriber.setMessageListener((MessageListener)new NotificationListener());
        }
        catch (NamingException e) {
            LOG.error("Unable to initialise context", (Throwable)e);
            return false;
        }
        catch (JMSException e) {
            LOG.error("JMS Error", (Throwable)e);
            return false;
        }
        return true;
    }

    private TopicConnection createConnection() throws JMSException {
        if (this.m_auth) {
            return this.m_fact.createTopicConnection(this.m_username, this.m_password);
        }
        return this.m_fact.createTopicConnection();
    }

    public boolean unsubsribe(String queueName) {
        this.m_checkForMessages = false;
        try {
            this.m_publisher.close();
            this.m_subscriber.close();
            this.m_session.close();
            this.m_connection.close();
        }
        catch (JMSException e) {
            LOG.error("Unable to close jms connection", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean publishNotification(IClusterNotificationMessage notification) {
        try {
            BytesMessage message = this.m_session.createBytesMessage();
            message.writeBytes(this.m_objectSerializer.serialize((Object)notification));
            this.m_publisher.publish((Message)message);
        }
        catch (JMSException e) {
            LOG.error("Unable to send message", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Unable to send message", (Throwable)e);
        }
        return false;
    }

    public void setListener(IPubSubMessageListener listener) {
        this.m_listener = listener;
    }

    public IPubSubMessageListener getListener() {
        return this.m_listener;
    }

    private class NotificationListener
    implements MessageListener {
        private NotificationListener() {
        }

        public void onMessage(Message message) {
            try {
                if (message instanceof BytesMessage) {
                    BytesMessage bm = (BytesMessage)message;
                    byte[] data = new byte[(int)bm.getBodyLength()];
                    bm.readBytes(data);
                    if (JMSPubSubMessageService.this.m_listener != null) {
                        JMSPubSubMessageService.this.m_listener.onMessage((IClusterNotificationMessage)JMSPubSubMessageService.this.m_objectSerializer.deserialize(data, IClusterNotificationMessage.class));
                    }
                }
            }
            catch (JMSException e) {
                LOG.error("Error receiving message", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Error receiving message", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("IO Error receiving message", (Throwable)e);
            }
        }
    }
}

