/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Level;
import org.apache.log4j.Log4jLoggerFactory;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.NullEnumeration;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class Category {
    protected final IScoutLogger logger;

    Category(String name) {
        this.logger = ScoutLogManager.getLogger((String)name);
    }

    public static Category getInstance(Class clazz) {
        return Log4jLoggerFactory.getLogger(clazz.getName());
    }

    public static Category getInstance(String name) {
        return Log4jLoggerFactory.getLogger(name);
    }

    public String getName() {
        return this.logger.getName();
    }

    public Enumeration getAllAppenders() {
        return NullEnumeration.getInstance();
    }

    public Level getEffectiveLevel() {
        return this.scoutLevelToLog4jLevel(this.logger.getLevel());
    }

    public final Level getLevel() {
        return this.scoutLevelToLog4jLevel(this.logger.getLevel());
    }

    public void setLevel(Level level) {
        this.logger.setLevel(this.log4jPriorityToScoutLevel(level));
    }

    @Deprecated
    public final Level getPriority() {
        return this.getLevel();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isEnabledFor(Priority p) {
        return this.logger.isLoggable(this.log4jPriorityToScoutLevel(p));
    }

    public void debug(Object message) {
        this.log(4, this.convertToString(message), null);
    }

    public void debug(Object message, Throwable t) {
        this.log(4, this.convertToString(message), t);
    }

    public void info(Object message) {
        this.log(3, this.convertToString(message), null);
    }

    public void info(Object message, Throwable t) {
        this.log(3, this.convertToString(message), t);
    }

    public void warn(Object message) {
        this.log(2, this.convertToString(message), null);
    }

    public void warn(Object message, Throwable t) {
        this.log(2, this.convertToString(message), t);
    }

    public void error(Object message) {
        this.log(1, this.convertToString(message), null);
    }

    public void error(Object message, Throwable t) {
        this.log(1, this.convertToString(message), t);
    }

    public void fatal(Object message) {
        this.log(1, this.convertToString(message), null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(1, this.convertToString(message), t);
    }

    public void log(String FQCN, Priority p, Object message, Throwable t) {
        this.log(this.log4jPriorityToScoutLevel(p), this.convertToString(message), t);
    }

    public void log(Priority p, Object message, Throwable t) {
        this.log(this.log4jPriorityToScoutLevel(p), this.convertToString(message), t);
    }

    public void log(Priority p, Object message) {
        this.log(this.log4jPriorityToScoutLevel(p), this.convertToString(message), null);
    }

    protected String convertToString(Object message) {
        return message == null ? null : message.toString();
    }

    protected Level scoutLevelToLog4jLevel(int scoutLogLevel) {
        switch (scoutLogLevel) {
            case 0: {
                return Level.OFF;
            }
            case 2: {
                return Level.WARN;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.DEBUG;
            }
            case 5: {
                return Level.TRACE;
            }
        }
        return Level.ERROR;
    }

    protected int log4jPriorityToScoutLevel(Priority p) {
        if (p == null) {
            return 1;
        }
        switch (p.level) {
            case 0x7FFFFFFF: {
                return 0;
            }
            case 30000: {
                return 2;
            }
            case 20000: {
                return 3;
            }
            case 10000: {
                return 4;
            }
            case -2147483648: {
                return 5;
            }
        }
        return 1;
    }

    protected void log(int scoutLevel, String message, Throwable t) {
        if (!this.logger.isLoggable(scoutLevel) || scoutLevel == 0 || message == null && t == null) {
            return;
        }
        switch (scoutLevel) {
            case 2: {
                this.logger.warn(message, t);
            }
            case 3: {
                this.logger.info(message, t);
            }
            case 4: {
                this.logger.debug(message, t);
            }
            case 5: {
                this.logger.trace(message, t);
            }
        }
        this.logger.error(message, t);
    }
}

